/*
 * merror.h
 *
 * This file is part of msmtp, an SMTP client.
 *
 * Copyright (C) 2004	Martin Lambers <marlam@users.sourceforge.net>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *   msmtp is released under the GPL with the additional exemption that
 *   compiling, linking, and/or using OpenSSL is allowed.
 */

#ifndef MERROR_H
#define MERROR_H

#define MERROR_BUFSIZE	512	/* the buffer size for error strings */

#define EOK	0	/* global code for OK */

/*
 * An error consists of an error number and an appropriate error message 
 * string (which may be NULL).
 */
typedef	struct
{
    int number;
    char *errstr;
} merror_t;

/*
 * merror()
 *
 * Create a merror_t. Note that the error string will be printed to a static
 * string, so subsequent calls to merror will overwrite it.
 * If 'number' is not EOK, 'format' must not be NULL! You can use "".
 * This is to let calling functions rely on (e.errstr != NULL) if an error
 * occured.
 */
merror_t merror(int number, char *format, ...);

/*
 * merror_ok()
 * 
 * Returns whether 'e' indicates success (error number EOK).
 */
int merror_ok(merror_t e);

#endif
