/*
 * paths.h
 *
 * This file is part of msmtp, an SMTP client.
 *
 * Copyright (C) 2004
 * Martin Lambers <marlam@users.sourceforge.net>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *   msmtp is released under the GPL with the additional exemption that
 *   compiling, linking, and/or using OpenSSL is allowed.
 */

#ifndef PATHS_H
#define PATHS_H

#include "merror.h"

#define PATHS_ENOMEM	1	/* Cannot allocate memory */
#define PATHS_ENOHOME	2	/* Cannot get user's directory */

/*
 * get_prgname()
 *
 * Get the program name from an argv[0]-like string.
 * Returns a pointer to a static buffer.
 */
char *get_prgname(char *argv0);

/*
 * get_default_conffile()
 *
 * Get the default filename of the configuration file.
 * It consists of a user directory (OS dependent; $HOME on UNIX) 
 * plus 'base'. (Example: $HOME/.msmtprc; base is ".msmtprc")
 * Returns a pointer to an  allocated string in 'dst'.
 * Used error codes: PATHS_ENOMEM, PATHS_ENOHOME
 */
merror_t get_default_conffile(char *base, char **dst);

/*
 * expand_tilde()
 *
 * If the first character of the given string is '~', it will be replaced by
 * the user's home directory. 
 * This function expects and returns an allocated string.
 * It never fails: If there is no home directory (or memory allocation fails), 
 * it doesn't change the filename. This way it does not depend on the 
 * availability of a home directory (->DOS).
 */
char *expand_tilde(char *filename);

#endif
