#include <stdlib.h>
#include <wchar.h>
#include "exitcode.h"
#include "retcodes.h"
#define  DSTR
#include "dstr.h"

/* Initialize a dynamic string */

void
InitializeDynamicString (struct dstr *s) {
  s->s = NULL;
  s->c = s->l = 0;
}

/* 
 * Create a dynamic wide string and copy into it an existing regular wide string.
 */

struct dstr *
MakeDynamicString(wchar_t *s) {
  struct dstr *new;
  int length;

  new = (struct dstr *) malloc(sizeof(struct dstr));
  if(new == NULL) exit(OUTOFMEMORY);
  length = wcslen(s);
  new->s = (wchar_t *) malloc((length + 1) * sizeof(wchar_t));
  if(new->s == NULL) exit(OUTOFMEMORY);
  wcscpy(new->s,s);
  new->c = new->l = length;
  return(new);
} 

/* 
 * Insert an existing wide string into a dynamic string.
 */

int
FillDynamicString(struct dstr *tgt, wchar_t *src) {
  int length;

  length = wcslen(src);
  if (length > tgt->c) {
    if(tgt->s != NULL) free( (void *) tgt->s);
    tgt->s = (wchar_t *) malloc((length + 1) * sizeof(wchar_t));
    if(tgt->s == NULL) return(ERROR);
    tgt->c = length;
  }
  wcscpy(tgt->s,src);
  tgt->l = length;
  return(SUCCESS);
} 
