/* d4libh.c 
 * Copyright (C) 2001 Jean-Jacques Sarton jj.sarton@t-online.de
 *
 * include file for the hih level function.
 *
 */

/*
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __D4LIBH__
# define __D4LIBH__

# if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
# endif

/* value for the mode argument of the Open function */

# define CONTROL 0
# define PRINTER 1
# define SCANNER 2

extern int Open(char *path, int mode);
extern int Close(int fd);
extern int Read(int fd, char *buf, size_t count);
extern int Write(int fd, char *buf, size_t count);

# if defined(__cplusplus) || defined(c_plusplus)
}
# endif
#endif
