%{

/* MToolsFM - A graphical Frontend to mtools
 * earlier versions under the name mfm
 * Copyright (c) 1999-2001 Christian Ospelkaus <christian@core-coutainville.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * er.l - A lexer for mtools stderr-output
 *
 * process this file with
 *   lex -Per er.l
 * to re-generate lex.er.c from er.l
 *
 * This lexer redefines the YY_INPUT macro,
 * so it will only work with flex. This should
 * be no problem since running lex is not part 
 * of the automated build process and the c-file
 * is included in the distribution and also very 
 * portable.
 *
 */

#undef YY_INPUT 
#define YY_INPUT(b,r,ms) (r=custom_input(b,ms))

#include <stdlib.h>
#include <string.h>
#include <libintl.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#define _(String) gettext (String)

#define MAX_BUTTON 7
#define BUTTON_OK 1
#define BUTTON_RETRY 2
#define BUTTON_YES 4
#define BUTTON_NO 8
#define BUTTON_SKIP 16
#define BUTTON_ALL 32
#define BUTTON_CANCEL 64

time_t starttime;
int logomode;

int display_message (const char *message, const char *title, unsigned int button_mask);
void warnme (const char *title, const char *text);
void mtoolserroutput(const char *); 
void wait_gtk_events(void);
void change_pixmap(int);
void set_main_window_state(int);

extern int mtools_version1, mtools_version2, mtools_version3;

int custom_input(char *buf, int max_size) {
  static char inbuff[2000];
  int newlogomode;
  int read_bytes=0;
  ssize_t now_read;
  while((!feof(erin))&&
        (now_read=read(fileno(erin),inbuff,((1999<max_size-read_bytes)?1999:(max_size-read_bytes))*sizeof(char)))) {
    wait_gtk_events();
    newlogomode=(abs(time(NULL)-starttime)%3)+1;
    if(newlogomode!=logomode) {
      logomode=newlogomode;
      change_pixmap(logomode);
    } 
    if(now_read>0) {
/*      fwrite(inbuff,sizeof(char),
             now_read*sizeof(char),
             stdout);
      printf("Read bytes: %i\n",now_read); */
      memcpy(buf+read_bytes,inbuff,now_read);
      read_bytes+=now_read;
    }
  }
  /* fwrite(buf,sizeof(char),
         read_bytes*sizeof(char),
         stdout); */
  return(read_bytes);
} 

%}

full Disk\ full\n
insert Can't\ open\ .+:\ Device\ not\ configured\nCannot\ initialize\ '.:'\n
insert1 Can't\ open\ .+:\ No\ such\ device\ or\ address\nCannot\ initialize\ '.:'\n
lock Can't\ open\ .+:\ Read-only\ file\ system\nCannot\ initialize\ '.:'\n
mdelnf mdel:\ File\ \".+:.+\"\ not\ found\n
mrennf mren:\ File\ \".+:.+\"\ not\ found\n
nondos init\ .+:\ non\ DOS\ media\nCannot\ initialize\ '.:'\n
busy Can't\ open\ .+:\ Device\ or\ resource\ busy\nCannot\ initialize\ '.:'\n
mtoolsversion Mtools\ version\ [0-9]+\.[0-9]+\.[0-9]+\,\ dated\ .+\nconfigured\ with\ the\ following\ options:\ .+\n
splitout creating\ file\ \`.+'\n

%%
{full} { mtoolserroutput(ertext); 
         return display_message(_("There is no space left on the target\n\
device. You can either insert\n\
a new disk, skip this file or cancel.\n\
What shall we do?\n"),_("Disk full"),BUTTON_RETRY|BUTTON_SKIP|BUTTON_CANCEL); }

({insert}|{insert1})+ { mtoolserroutput(ertext); 
              warnme(_("No floppy in drive"),
                     _("There is no floppy in the drive.")); }

({lock})+ { mtoolserroutput(ertext); 
            warnme(_("Read-only drive"),
                   _("This floppy is read-only. If you want to\n\
write to it, remove the write-protection.")); }

{mdelnf}|{mrennf} { mtoolserroutput(ertext); 
                    warnme(_("File not found"),
                           _("I was unable to locate the file\n\
on the disk. Maybe you inserted\n\
another floppy in between?")); }

({nondos})+ { mtoolserroutput(ertext); 
              warnme(_("Non DOS media"),
                     _("This does not look like a DOS floppy.\n\
Maybe it is minix, ext2 or some other format.\n\
In order to read such a floppy, you have to\n\
mount it.")); }

({busy})+ { mtoolserroutput(ertext); 
            warnme(_("Device or resource busy"),
                   _("I was unable to access the floppy.\n\
This means that probably some other\n\
application is using the floppy. Perhaps\n\
the floppy is already mounted?")); }

{mtoolsversion} { char *per1, *per2, *per3;
                  per1=ertext+15;
                  per2=strchr(per1,'.')+1;
                  per3=strchr(per2,'.')+1; 
                  mtools_version1=atoi(per1);
                  mtools_version2=atoi(per2);
                  mtools_version3=atoi(per3); }
{splitout} { char bakchar; 
             bakchar=ertext[erleng-2]; 
             ertext[erleng-2]='\0'; 
             fprintf(erout,"+ %s ",ertext+15);
             ertext[erleng-2]=bakchar; }

(.{8,8})\ (.{3,3})\ (([0-9 ]{9,9})|(<DIR>\ \ \ \ ))\ ([0-9]{2,2})-([0-9]{2,2})-([0-9]{4,4})\ \ ([0-9 ]{2,2}):([0-9]{2,2})\ .* { return(255); }

\ ?Directory\ for.* { ; }
\ ?Volume\ Serial\ Number\ is.* { ; }
\ ?Volume\ in\ drive.* { ; }
(\ *)\n { ; }
([0-9 ]{9,9})\ file(s|\ )\ ([0-9 ]{19,19})\ bytes.* { ; }
No\ files\n { ; }
\ ([0-9 ]{34,34})\ bytes\ free\n { char *pos; for(pos=ertext;*pos==' ';pos++); mtoolserroutput(pos); }

.|\n               { mtoolserroutput(ertext); }
%%

int erwrap()
{
  return (1);
} 

int 
er_interface( FILE * infile, FILE * parserout ) 
{
  int result;
  set_main_window_state(0);
  starttime=time(NULL);
  erin=infile;
  fcntl(fileno(erin),F_SETFL,O_NONBLOCK|fcntl(fileno(erin),F_GETFL));
  erout=parserout;
  logomode=(abs(time(NULL)-starttime))%3+1;
  change_pixmap(logomode);
  result=erlex();
  change_pixmap(0);
  set_main_window_state(1);
  return result;
}
  
