import os.path, shutil
import zope.interface

from multibuild.builder.hooks import interfaces, register, support

class Hook(support.Hook):
    zope.interface.implements(interfaces.IHookBuildResult)

    name = "copy-packages"
    default_priority = 50

    def result(self, build):
        files = self.get_files(build)
        out = os.path.expanduser(build.extra.get('result-dir', "~/build"))
        for f in files:
            i = os.path.join(build.environment.build_path, f)
            shutil.copy2(i, out)

register(Hook)
