#define _LARGEFILE64_SOURCE     /* required for GLIBC to enable stat64 and friends */
#include <sys/types.h>
#include <regex.h>
#include <string.h>

#include "mt.h"
#include "mem.h"
#include "utils.h"
#include "globals.h"


void store_for_diff(proginfo *cur, char *string)
{
	cur -> bcur = (char **)myrealloc(cur -> bcur, sizeof(char *) * (cur -> ncur + 1), "store_for_diff: difference list");

	(cur -> bcur)[cur -> ncur] = mystrdup(string, "store_for_diff");

	cur -> ncur++;
}

void generate_diff(int winnr, proginfo *cur)
{
	int loop_cur;
	int search_offset = 0;

	/* calculate & print difference */
	for(loop_cur=0; loop_cur < cur -> ncur; loop_cur++)
	{
		int loop_prev;
		char found = 0;

		for(loop_prev=0; loop_prev < cur -> nprev; loop_prev++)
		{
			if (strcmp((cur -> bprev)[(search_offset + loop_prev) % cur -> nprev], (cur -> bcur)[loop_cur]) == 0)
			{
				found = 1;
				break;
			}
		}

		if (!found)
		{
			/* output cur[loop] */
			emit_to_buffer_and_term(winnr, cur, cur -> bcur[loop_cur]);
			search_offset = 0;
		}
		else
		{
			search_offset = loop_prev + 1;
		}
	}
	update_panels();

	/* free up previous */
	delete_array(cur -> bprev, cur -> nprev);

	/* remember current */
	cur -> bprev = cur -> bcur;
	cur -> nprev = cur -> ncur;
	cur -> bcur = NULL;
	cur -> ncur = 0;

	/* update statusline */
	update_statusline(pi[winnr].status, winnr, cur);
}
