/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: op.c,v 1.4 2003/04/20 21:29:10 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdlib.h>

#include	"murasaki.h"
#include	"murasaki_ieee1394.h"

MU_ieee1394_config_t config;

static void
get_info_ieee1394(void)
{
	if (get_id_ieee1394(&config) == INVALID)	/* always GOOD */
		exit(1);
}

struct mu_op mu_op = {
	device: ieee1394,
	device_name: MU_ARG_IEEE1394,
	command: MU_MURASAKI "." MU_ARG_IEEE1394,
	mappath: MU_CONF_DIR "/" MU_IEEE1394MAP,
	default_mapname: MU_DEFAULT_IEEE1394MAP,
	action: ACTION_NONE,
	config: &config,
	get_info: get_info_ieee1394,
	get_list: create_modulelist,
	match_map: match_config,
	run: load_module,
	prepare: exec_script,
	end: exec_script,
};
