/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: murasaki.h,v 3.12 2003/04/20 21:30:44 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#ifndef	_MURASAKI_H
#define	_MURASAKI_H

#include	<syslog.h>
#include	"datatype.h"
#include	"env.h"

#define	LOG_LEVEL	LOG_INFO

#ifdef	DEBUG
#define	DPRINTF( args... )	syslog(args)
#define	DPRINT_LIST(list)	print_list(list)
#else
#define	DPRINTF( args... )
#define	DPRINT_LIST(list)
#endif

/* name about file */
#define	MU_MURASAKI	"murasaki"
#define	MU_ARG_USB	"usb"
#define	MU_ARG_PCI	"pci"
#define	MU_ARG_NET	"net"
#define	MU_ARG_IEEE1394	"ieee1394"

/* path about /proc */
#define	MODPROBE_FILE	"/proc/sys/kernel/modprobe"
#define	HOTPLUG_FILE	"/proc/sys/kernel/hotplug"
#define DEFAULT_HOTPLUG	"/sbin/hotplug"
#define	get_loader()	get_path(MODPROBE_FILE)
#define get_hotplug()	get_path(HOTPLUG_FILE)

#define	LIST_MAX		16
/* prefix for alias */
#define	ALIAS_STR		"alias-"

/* common */
extern struct mu_op mu_op;
extern int flag_debug;
extern int flag_beep;
extern char *module_list[];
extern char *script_list[];
extern char *device_list[];
extern char *config_list[];

extern int match_config(char **,char *,char *,void *);
extern void print_config(void *);
extern void inform_config(void *);
/* action.c */
extern int get_action(struct mu_op *);
/* beep.c */
extern void beep(int);
/* depend.c */
extern int get_depend(char **);
extern int get_modulescript(char **,char **,int );
extern int get_devicescript(char **,char **,int );
extern int check_config(char *);
/* list.c */
extern int add_to_list(char **,char *,int);
extern int count_of_list(char **);
extern void remove_from_list(char **,int);
#ifdef	DEBUG
extern void print_list(char **);
#endif
/* loader.c */
extern void executing(char *,char **argv,int );
extern int load_module(struct mu_op *);
extern int create_modulelist(struct mu_op *);
/* script.c */
extern void exec_device_script(struct mu_op *,int );
extern void exec_script(struct mu_op *,int );
/* path.c */
extern char * get_path(char *);
/* sticky.c */
void delete_stickymodule(char **);
#endif	/* _MURASAKI_H */
