/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: print.c,v 1.3 2004/09/12 08:04:00 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<unistd.h>

#include	"murasaki.h"
#include	"murasaki_ieee1394.h"

void
print_config(mu_op_t *opp)
{
	MU_ieee1394_config_t *config = opp->config;

	config->match_flags = 0;
	if (config->vendor != 0)
		config->match_flags |= IEEE1394_MATCH_VENDOR_ID;
	/* 'model' is ignored */
#if 0
	if (config->model != 0)
		config->match_flags |= IEEE1394_MATCH_MODEL_ID;
#else
		config->model = 0;
#endif
	if (config->specifier != 0)
		config->match_flags |= IEEE1394_MATCH_SPECIFIER_ID;
	if (config->version != 0)
		config->match_flags |= IEEE1394_MATCH_VERSION;

	
	LOG_OPP_STD("MODULE 0x%08x 0x%06x 0x%06x 0x%06x 0x%06x",
		config->match_flags,
		config->vendor,
		config->model,
		config->specifier,
		config->version);
}

void
inform_config(mu_op_t *opp)
{
	MU_ieee1394_config_t *config = opp->config;

	/* ignore guid */
	LOG_OPP_STD("vendor:0x%x specifier:0x%x version:0x%x",
		config->vendor,
		config->specifier,
		config->version);
}
