/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: murasaki.h,v 3.26 2004/02/19 00:44:47 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#ifndef	_MURASAKI_H
#define	_MURASAKI_H

#include	<syslog.h>
#include	"datatype.h"
#include	"env.h"
#include	<sys/types.h>	/* for uid_t */

/* name about file */
#define	MU_MURASAKI		"murasaki"
#define	MU_ARG_USB		"usb"
#define	MU_ARG_PCI		"pci"
#define	MU_ARG_IEEE1394		"ieee1394"
#define	MU_ARG_PCMCIA		"pcmcia_socket"
#define MU_ARG_GENERIC		"generic"
#define MU_ARG_INPUT		"input"

#define	MU_CMD(agent)		MU_MURASAKI "." agent
#define	MU_INIT(agent)		"init." agent
#define	MU_MAP_PATH(map)	MU_CONF_DIR "/" map

#define	MU_INIT_USB		MU_INIT(MU_ARG_USB)
#define	MU_INIT_PCI		MU_INIT(MU_ARG_PCI)
#define	MU_INIT_IEEE1394	MU_INIT(MU_ARG_IEEE1394)
#define	MU_INIT_PCMCIA		MU_INIT(MU_ARG_PCMCIA)

#define	LOG_LEVEL	LOG_INFO

/* path about /proc */
#define	MODPROBE_FILE	"/proc/sys/kernel/modprobe"
#define	HOTPLUG_FILE	"/proc/sys/kernel/hotplug"
#define DEFAULT_HOTPLUG	"/sbin/hotplug"
#define	get_loader()	get_path(MODPROBE_FILE)
#define get_hotplug()	get_path(HOTPLUG_FILE)

/* flag */
#define	FLAG_ON(flag,value)	(flag) |= (value)
#define	FLAG_OFF(flag,value)	(flag) &= ~(value)
#define	FLAG_CHECK(flag,value)	((flag) & (value))
#define	FLAG_NONE	0
#define	FLAG_KERNEL25	1
#define	FLAG_BEEP	(1<<1)
#define	FLAG_SYSFS	(1<<2)

/* about SYSFS */
#define	SYSFS_VALUE10(path,ptr,msg_level)	sysfs_value((path),(ptr),10,0,msg_level)
#define	SYSFS_VALUE16(path,ptr,msg_level)	sysfs_value((path),(ptr),16,0,msg_level)
#define	SYSFS_VALUE10_WAIT(path,ptr,wait,msg_level) sysfs_value((path),(ptr),10,wait,msg_level)
#define	SYSFS_VALUE16_WAIT(path,ptr,wait,msg_level) sysfs_value((path),(ptr),16,wait,msg_level)

#define	LOG(level,val,args...)		if ((level) <= (val)) {\
						syslog(LOG_LEVEL,args); \
					}

#define	LOG_OPP(level,args...)		if ((level) <= opp->msg_level) {\
						syslog(LOG_LEVEL,args); \
					}

#define	LOG_OPP_QUIET(args...)		if (MU_MSG_QUIET <= opp->msg_level) {\
						syslog(LOG_LEVEL,args); \
					}

#define	LOG_OPP_WHISPER(args...)	if (MU_MSG_WHISPER <= opp->msg_level) {\
						syslog(LOG_LEVEL,args); \
					}

#define	LOG_OPP_STD(args...)		if (MU_MSG_STD <= opp->msg_level) {\
						syslog(LOG_LEVEL,args); \
					}

#define	LOG_OPP_TRACE(args...)		if (MU_MSG_TRACE <= opp->msg_level) {\
						syslog(LOG_LEVEL,args); \
					}

#define	LOG_OPP_DESC(args...)		if (MU_MSG_DESC <= opp->msg_level) {\
						syslog(LOG_LEVEL,args); \
					}

#define	LOG_ARGS(level,val,head,arg)	if ((level) <= (val)) {\
						print_args(head,arg); \
					}

/* prefix for alias */
#define	ALIAS_STR		"alias-"

/* common */
extern mu_op_t mu_op;

/* common function name */
extern int match_config(mu_op_t *,char *,char *);
extern void print_config(mu_op_t *);
extern void inform_config(mu_op_t *);

/* action.c */
extern int get_action(mu_op_t *);
/* beep.c */
extern void beep(int,int);
/* depend.c */
extern int get_depend(mu_op_t *);
extern int get_module_script(mu_op_t *,int );
extern int get_device_script(mu_op_t *,int );
extern int check_config(char *,int );
extern int check_config_val(char *,int );
extern int get_resource(char *,list_t *,int );
/* list.c */
extern int init_list(list_t *,int);
extern int realloc_list(list_t *);
extern void free_list(list_t *);
extern int find_str_list(list_t *,char *);
extern int find_mem_list(list_t *,char *,char *);
extern int add_to_list(list_t *,char *,int );
extern int count_of_list(list_t *);
extern void remove_from_list(list_t *,int);
#ifdef	DEBUG
extern void print_list(char **);
#endif
/* loader.c */
extern void executing(mu_op_t *,char **,int );
extern int load_module(mu_op_t *);
extern int create_modulelist(mu_op_t *);
/* script.c */
extern void exec_device_script(mu_op_t *,int );
extern void exec_script(mu_op_t *,int );
/* path.c */
extern char * get_path(char *);
/* filelist.c */
extern int list_from_file(char *,list_t *);
/* sysfs.c */
extern char *check_sysfs(mu_op_t *);
extern void set_devpath(mu_op_t *);
extern char *make_devpath(mu_op_t *,char *);
/* value.c */
extern int sysfs_value(char *,unsigned int *,int,int,int);
/* save_sysdir.c */
extern void save_sysfs(mu_op_t *,char *);
/* proc.c */
extern char *alloc_read(char *,int *);
/* exec_sysfs.c */
extern void execute_hotplug_sysfs(char *,char *,int ,int);
/* init.c */
extern int init_argument(char **,char **,char *);
/* mmap.c */
extern char *map_file(char *,unsigned int *,int);
/* string.c */
extern char *alloc_module(char *,int );
/* debug.c */
extern void print_args(char *,char **);
extern int get_msg_level(void);
/* coldplug.c */
extern char * coldplug_init(char *,char *,int *);
/* permission.c */
extern int check_file_x(char *,int );

#endif	/* _MURASAKI_H */

