/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: murasaki_pci.h,v 1.6 2004/02/06 00:22:54 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#ifndef	_MURASASKI_PCI_H
#define	_MURASASKI_PCI_H

#define	PCI_PROC_BUF	256

#include	<linux/types.h>
typedef unsigned long kernel_ulong_t;
#include	<linux/pci.h>

/* PCI configuration */
typedef struct {
	unsigned int vendor;
	unsigned int device;
} MU_pci_id_t;

typedef struct {
	char *name;
	unsigned int class;
	unsigned int class_mask;
	MU_pci_id_t id;
	MU_pci_id_t sub_id;
	char *slot;
} MU_pci_config_t;

extern int get_id_pci_class(mu_op_t *);
extern int get_id_pci_id(mu_op_t *);
extern int get_id_pci_slot(mu_op_t *);
/* sysfs */
extern int get_sysfs_class(mu_op_t *);
extern int get_sysfs_vendor(mu_op_t *);
extern int get_sysfs_device(mu_op_t *);
extern int sysfs_init(mu_op_t *);

#endif	/* _MURASAKI_PCI_H */
