/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: array.c,v 1.3 2004/09/12 08:04:32 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>

#include	"murasaki.h"
#include	"murasaki_input.h"

static void
get_id_input_array_sep(char *start,char *end,unsigned long *array,int array_size,char sep_char)
{
	int idx;
	char *ptr;

	memset(array,0x00,sizeof(long)*array_size);
	idx = array_size - 1;
	for (ptr = end;idx >= 0 && ptr >= start;ptr--) {
		if (*ptr != ' ')
			break;
	}
	for (;idx >= 0 && ptr >= start;ptr--) {
		if(ptr == start) {
			array[idx--] = strtoul(ptr,NULL,16);
		} else if (*ptr == sep_char) {
			array[idx--] = strtoul(ptr + 1,NULL,16);
		}
	}
}

/*
 * format: x( x x...)
 */
static int
get_id_input_array_space(char *name,unsigned long *array,int array_size)
{
	char *ptr;
	int len;

	ptr = getenv(name);
	if (ptr == NULL) {
		array[array_size - 1] = 0;	/* not match any value */
		return GOOD;
	}
	len = strlen(ptr);

	get_id_input_array_sep(ptr,ptr+len-1,array,array_size,' ');

	return GOOD;
}

/*
 * format: x(:x:x...)
 */

int
get_id_input_array_colon(char *start,char *end,unsigned long *array,int array_size)
{
	get_id_input_array_sep(start,end,array,array_size,':');

	return GOOD;
}


int
get_id_input_array_space_all(mu_op_t *opp)
{
	MU_input_config_t *config = opp->config;
	int i;
	struct {
		char *env_name;
		unsigned long *array;
		int array_size;
	} mu_input_array[] = {
	{"EV",	config->evbit,	NBITS(EV_MAX)},
	{"KEY",	config->keybit,	NBITS(KEY_MAX)},
	{"REL",	config->relbit,	NBITS(REL_MAX)},
	{"ABS",	config->absbit,	NBITS(ABS_MAX)},
	{"MSC",	config->mscbit,	NBITS(MSC_MAX)},
	{"LED",	config->ledbit,	NBITS(LED_MAX)},
	{"SND",	config->sndbit,	NBITS(SND_MAX)},
	{"FF",	config->ffbit,	NBITS(FF_MAX)},
	{NULL,NULL,0}};

	for(i = 0;mu_input_array[i].env_name != NULL;i++) {
		if (get_id_input_array_space(mu_input_array[i].env_name,mu_input_array[i].array,mu_input_array[i].array_size) == INVALID) {
			LOG_OPP_QUIET("%s is invalid",
					mu_input_array[i].env_name);

			return INVALID;
		}
	}

	return GOOD;
}


