/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: op.c,v 1.2 2004/09/12 08:05:13 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdlib.h>

#include	"murasaki.h"
#include	"murasaki_input.h"

static MU_input_config_t config;

static int
get_info_input(mu_op_t *opp)
{
	if (get_id_input_product(opp) != GOOD)
		return INVALID;
	if (get_id_input_array_space_all(opp) != GOOD)
		return INVALID;

	return GOOD;
}

mu_op_t mu_op = {
	flag: FLAG_BEEP,
	msg_level: MU_MSG_STD,
	device: input,
	device_name: MU_ARG_INPUT,
	command: MU_CMD(MU_ARG_INPUT),
	mappath: {MU_MAP_PATH(MU_INPUTMAP),MU_DEFAULT_INPUTMAP,NULL,NULL},
	action: ACTION_NONE,
	config: &config,
	sysfs: NULL,
	devpath: NULL,

	get_info: get_info_input,
	get_list: create_modulelist,
	match_map: match_config,
	run: load_module,
	prepare: exec_script,
	end: exec_script,
};
