/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: print.c,v 1.2 2004/09/12 08:05:45 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */

#include	"murasaki.h"
#include	"murasaki_input.h"

/*
 * module         matchBits bustype vendor product version evBits keyBits relBits absBits mscBits ledBits sndBits ffBits driver_info
 */

#define	PRINT_BUF_SIZE	512

void
print_config(mu_op_t *opp)
{
	MU_input_config_t *config = opp->config;
	char buf[PRINT_BUF_SIZE],*scratch;

	config->match_flags = 0;
	/* BUSTYPE */
	if (config->bustype != 0)
		config->match_flags |= INPUT_DEVICE_ID_MATCH_BUS;
	/* VENDOR */
	if (config->vendor != 0)
		config->match_flags |= INPUT_DEVICE_ID_MATCH_VENDOR;
	/* PRODUCT */
	if (config->product != 0)
		config->match_flags |= INPUT_DEVICE_ID_MATCH_PRODUCT;
	/* VERSION */
	if (config->version != 0)
		config->match_flags |= INPUT_DEVICE_ID_MATCH_VERSION;
	/* EV */
	if (config->evbit[NBITS(EV_MAX)-1] != 0)
		config->match_flags |= INPUT_DEVICE_ID_MATCH_EVBIT;
	/* KEY */
	if (config->keybit[NBITS(KEY_MAX)-1] != 0)
		config->match_flags |= INPUT_DEVICE_ID_MATCH_KEYBIT;
	/* REL */
	if (config->relbit[NBITS(REL_MAX)-1] != 0)
		config->match_flags |= INPUT_DEVICE_ID_MATCH_RELBIT;
	/* ABS */
	if (config->absbit[NBITS(ABS_MAX)-1] != 0)
		config->match_flags |= INPUT_DEVICE_ID_MATCH_ABSBIT;
	/* MSC */
	if (config->mscbit[NBITS(MSC_MAX)-1] != 0)
		config->match_flags |= INPUT_DEVICE_ID_MATCH_MSCBIT;
	/* LED */
	if (config->ledbit[NBITS(LED_MAX)-1] != 0)
		config->match_flags |= INPUT_DEVICE_ID_MATCH_LEDBIT;
	/* SND */
	if (config->sndbit[NBITS(SND_MAX)-1] != 0)
		config->match_flags |= INPUT_DEVICE_ID_MATCH_SNDBIT;
	/* FF */
	if (config->ffbit[NBITS(FF_MAX)-1] != 0)
		config->match_flags |= INPUT_DEVICE_ID_MATCH_FFBIT;

	if (config->match_flags == 0)
		config->driver_info = 1;

	scratch = buf;

	scratch = push_bit(scratch,NULL,config->evbit,NBITS(EV_MAX));
	scratch = push_bit(scratch,NULL,config->keybit,NBITS(KEY_MAX));
	scratch = push_bit(scratch,NULL,config->relbit,NBITS(REL_MAX));
	scratch = push_bit(scratch,NULL,config->absbit,NBITS(ABS_MAX));
	scratch = push_bit(scratch,NULL,config->mscbit,NBITS(MSC_MAX));
	scratch = push_bit(scratch,NULL,config->ledbit,NBITS(LED_MAX));
	scratch = push_bit(scratch,NULL,config->sndbit,NBITS(SND_MAX));
	scratch = push_bit(scratch,NULL,config->ffbit,NBITS(FF_MAX));

	LOG_OPP_STD("MODULE 0x%x 0x%x 0x%x 0x%x 0x%x%s 0x%lx",
		config->match_flags,
		config->bustype,
		config->vendor,
		config->product,
		config->version,
		buf,
		config->driver_info);
}

void
inform_config(mu_op_t *opp)
{
	MU_input_config_t *config = opp->config;
	char buf[PRINT_BUF_SIZE],*scratch;

	scratch = buf;

	scratch = push_bit(scratch,"evbit",config->evbit,NBITS(EV_MAX));
	scratch = push_bit(scratch,"keybit",config->keybit,NBITS(KEY_MAX));
	scratch = push_bit(scratch,"relbit",config->relbit,NBITS(REL_MAX));
	scratch = push_bit(scratch,"absbit",config->absbit,NBITS(ABS_MAX));
	scratch = push_bit(scratch,"mscbit",config->mscbit,NBITS(MSC_MAX));
	scratch = push_bit(scratch,"ledbit",config->ledbit,NBITS(LED_MAX));
	scratch = push_bit(scratch,"sndbit",config->sndbit,NBITS(SND_MAX));
	scratch = push_bit(scratch,"ffbit",config->ffbit,NBITS(FF_MAX));
	
	LOG_OPP_STD("bustype:0x%x vendor0x%x product0x%x version:0x%x %s",
		config->bustype,
		config->vendor,
		config->product,
		config->version,
		buf);
}
