/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: product.c,v 1.2 2004/09/12 08:06:46 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<stdlib.h>

#include	"murasaki.h"
#include	"murasaki_input.h"

#define		SEP	'/'

/*
 * format: x/x/x/x
 */

int
get_id_input_product(mu_op_t *opp)
{
	char *ptr;
	char *sep;
	MU_input_config_t *config;

	config = (MU_input_config_t *)opp->config;

	ptr = getenv("PRODUCT");
	if (ptr == NULL) {
		config->bustype = 0;
		config->vendor = 0;
		config->product = 0;
		config->version = 0;
		return INVALID;
	}
	
	config->bustype = (__u16)strtoul(ptr,&sep,16);	/* bustype */
	LOG_OPP_DESC("bustype 0x%x",config->bustype);
	if (*sep != SEP)
		return INVALID;

	ptr = sep + 1;
	config->vendor = (__u16)strtoul(ptr,&sep,16);	/* vendor */
	LOG_OPP_DESC("vendor 0x%x",config->vendor);
	if (*sep != SEP)
		return INVALID;

	ptr = sep + 1;
	config->product = (__u16)strtoul(ptr,&sep,16);	/* product */
	LOG_OPP_DESC("product 0x%x",config->product);
	if (*sep != SEP)
		return INVALID;

	ptr = sep + 1;
	config->version = (__u16)strtoul(ptr,NULL,16);	/* version */
	LOG_OPP_DESC("version 0x%x",config->version);

	return GOOD;	
}
