/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: init.c,v 1.1 2004/02/05 23:50:47 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<stdlib.h>

#include	"murasaki.h"

/* 
 * argv[0] : hotplug full path
 * argv[1] : agent name
 */
int
init_argument(char **argv,char **envp,char *device)
{
	int i;
	static char *hotplug_path = NULL;
	char *ptr;

	if (hotplug_path == NULL && (hotplug_path = get_hotplug()) == NULL)
		hotplug_path = DEFAULT_HOTPLUG;

	i = 0;
	argv[i++] = hotplug_path;
	argv[i++] = device;
	argv[i] = 0;

	i = 0;
	if ((ptr = getenv("MURASAKI_BEEP")) != NULL) {
		envp[i++] = ptr-14;	/* 14:MURASAKI_BEEP= */
	}
	envp[i++] = "HOME=/";
	envp[i++] = "PATH=/sbin:/bin:/usr/sbin:/usr/bin";
	envp[i++] = "ACTION=add";

	return i;
}
