/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotAster.com>
 *
 *  $Id: mmap.c,v 1.3 2004/09/12 07:44:13 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<unistd.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<fcntl.h>
#include	<sys/mman.h>

#include	"murasaki.h"

char *
map_file(char *fname,unsigned int *size,int msg_level)
{
	int fd;
	struct stat st;
	char *mp;

	if ((fd = open(fname,O_RDONLY)) == -1) {
		LOG(MU_MSG_TRACE,msg_level,"open error %s",fname);
		return NULL;
	}
	if (fstat(fd,&st) == -1) {
		LOG(MU_MSG_TRACE,msg_level,"fstat error %s",fname);
		close(fd);
		return NULL;
	}
	*size = st.st_size;
	if ((mp = mmap(0,*size,PROT_READ,MAP_SHARED,fd,0)) == MAP_FAILED) {
		LOG(MU_MSG_TRACE,msg_level,"mmap error %s",fname);
		close(fd);
		return NULL;
	}
	close(fd);

	return mp;
}
