/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: id.c,v 1.5 2004/09/12 07:59:36 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<stdlib.h>

#include	"murasaki.h"
#include	"murasaki_pci.h"

#define		SEP	':'	/* changed 2.4.0-test12-pre8 */

/*
 * format: x/x
 */

static int
get_id_sub(MU_pci_id_t *id,char *ptr)
{
	char *sep;

	id->vendor = strtoul(ptr,&sep,16);
	if (*sep != SEP)
		return INVALID;

	ptr = sep + 1;
	id->device = strtoul(ptr,NULL,16);
	
	return GOOD;
}

int
get_id_pci_id(mu_op_t *opp)
{
	char *ptr;
	MU_pci_id_t id;
	MU_pci_config_t *config;

	config = opp->config;

	ptr = getenv("PCI_ID");
	if (ptr == NULL)
		return INVALID;
	if(get_id_sub(&id,ptr) != GOOD)		/* returns must be GOOD */
		return INVALID;
	config->id = id;
	LOG_OPP_DESC("vendor 0x%x device 0x%x",
		id.vendor,id.device);
	ptr = getenv("PCI_SUBSYS_ID");
	if (ptr == NULL)
		return INVALID;
	if(get_id_sub(&id,ptr) != GOOD)		/* returns must be GOOD */
		return INVALID;
	config->sub_id = id;
	LOG_OPP_DESC("subvendor 0x%x subdevice 0x%x",
		id.vendor,id.device);

	return GOOD;
}
