/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: match.c,v 1.7 2004/09/12 08:00:12 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 *
 * Fix: matching invalid value
 *			Shun-ichi TAHARA <jado@flowernet.gr.jp>
 */
#include	<stdio.h>
#include	<string.h>
#include	<stdlib.h>

#include	"murasaki.h"
#include	"murasaki_pci.h"

#define PCI_ANY_ID (~0)		/* from linux/pci.h */

#define	CHAR_COMMENT	'#'
#define	CHAR_RSEP		'\n'

#define	ST_COMMENT		255
#define	ST_SKIP			(ST_COMMENT - 1)
#define	ST_MODULE		1
#define	ST_VENDOR		(ST_MODULE + 1)
#define	ST_DEVICE		(ST_VENDOR + 1)
#define	ST_SUB_VENDOR	(ST_DEVICE + 1)
#define	ST_SUB_DEVICE	(ST_SUB_VENDOR + 1)
#define	ST_CLASS		(ST_SUB_DEVICE + 1)
#define	ST_CLASS_MASK	(ST_CLASS + 1)
#define	ST_DRIVER_DATA	(ST_CLASS_MASK + 1)

static int
real_match(MU_pci_config_t *active,MU_pci_config_t *map)
{
	if (!active->id.vendor && !active->sub_id.vendor && !active->class)
		return INVALID;
	if (active->id.vendor &&
	    ((map->id.vendor != PCI_ANY_ID && active->id.vendor != map->id.vendor) ||
	     (map->id.device != PCI_ANY_ID && active->id.device != map->id.device)))
		return INVALID;
	if (active->sub_id.vendor &&
	    ((map->sub_id.vendor != PCI_ANY_ID && active->sub_id.vendor != map->sub_id.vendor) ||
	     (map->sub_id.device != PCI_ANY_ID && active->sub_id.device != map->sub_id.device)))
		return INVALID;
	if (active->class && (active->class & map->class_mask) != map->class)
		return INVALID;

	return GOOD;
}

/*
 * called if msg_level >= MU_MSG_STD
 */
static void
print_matching(MU_pci_config_t *map,char *module)
{
	syslog(LOG_LEVEL,"MATCH(%s) -> vendor:0x%x device:0x%x subvendor:0x%x subdevice 0x%x class:0x%x class_mask:0x%x",
		module,
		map->id.vendor,map->id.device,
		map->sub_id.vendor,map->sub_id.device,
		map->class,map->class_mask);
}

int
match_config(mu_op_t *opp,char *start,char *end)
{
	MU_pci_config_t *config = opp->config,map;
	char *ptr,*module,*module_start;
	int status = ST_MODULE;
	unsigned int value,module_len = 0,i;
	char *fwdp;

	for(module_start = ptr = start; ptr < end;ptr++) {
		if (status == ST_COMMENT) {
			while(*ptr != CHAR_RSEP) {
				if (ptr >= end)
					goto error_return;
				ptr++;
			}
			status = ST_MODULE;
			continue;
		} else if (*ptr == CHAR_COMMENT) {
			status = ST_COMMENT;
			continue;
		}
		if (status == ST_MODULE) {
			module_start = ptr;
			while(*ptr != ' ' && *ptr != '\t') {
				if (ptr >= end)
					goto error_return;
				ptr++;
			}
			/* ptr == next to module end */
			module_len = ptr - module_start;
			/*
			 * check excepted modules
			 */
			if ((i = find_mem_list(&(opp->except_list),module_start,ptr)) != NOT_FOUND) {
				status = ST_COMMENT;
				LOG_OPP_STD("%s was skipped in pcimap",opp->except_list.list[i]);
				continue;
			}
		} else {
			value = (unsigned int)strtoul(ptr,&fwdp,0);
			ptr = fwdp;
			switch(status) {
			case ST_VENDOR:
				map.id.vendor = value;
				break;
			case ST_DEVICE:
				map.id.device = value;
				break;
			case ST_SUB_VENDOR:
				map.sub_id.vendor = value;
				break;
			case ST_SUB_DEVICE:
				map.sub_id.device = value;
				break;
			case ST_CLASS:
				map.class = value;
				break;
			case ST_CLASS_MASK:
				map.class_mask = value;
				break;
			case ST_DRIVER_DATA:	/* ignore */
				status = ST_MODULE;
				if (real_match(config,&map) == GOOD) {
					module = alloc_module(module_start,module_len);
					if (module == NULL)
						goto error_return;
					if (opp->msg_level >= MU_MSG_STD)
						print_matching(&map,module);
					if (add_to_list(&(opp->module_list),module,opp->msg_level) == INVALID)
						goto error_return;
				}
				continue;
			default:
				goto error_return;
			}
		}
		status++;
	}

	return GOOD;

error_return:
	return INVALID;
}

