/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: op.c,v 1.8 2004/09/12 08:00:31 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdlib.h>

#include	"murasaki.h"
#include	"murasaki_pci.h"

MU_pci_config_t config;

static int
get_info_pci(mu_op_t *opp)
{
	if (FLAG_CHECK(opp->flag,FLAG_SYSFS) && opp->devpath != NULL) {
		if (sysfs_init(opp) == INVALID)
			return INVALID;
		if (get_sysfs_class(opp) == INVALID)
			return INVALID;
		if (get_sysfs_vendor(opp) == INVALID)
			return INVALID;
		if (get_sysfs_device(opp) == INVALID)
			return INVALID;
	} else {
		if (get_id_pci_class(opp) == INVALID)
			return INVALID;
		if (get_id_pci_id(opp) == INVALID)
			return INVALID;
	}

	return GOOD;
}


mu_op_t mu_op = {
	flag: FLAG_BEEP,
	msg_level: MU_MSG_STD,
	device: pci,
	device_name: MU_ARG_PCI,
	command: MU_MURASAKI "." MU_ARG_PCI,
	mappath: {MU_CONF_DIR "/" MU_PCIMAP,MU_DEFAULT_PCIMAP,NULL,NULL},
	action: ACTION_NONE,
	config: &config,
	sysfs: NULL,
	devpath: NULL,

	get_info: get_info_pci,
	get_list: create_modulelist,
	match_map: match_config,
	run: load_module,
	prepare: exec_script,
	end: exec_script,
};
