/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: sysfs.c,v 1.4 2004/09/12 08:01:24 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<string.h>

#include	"murasaki.h"
#include	"murasaki_pci.h"

int
sysfs_init(mu_op_t *opp)
{
	char *path;
	unsigned int dummy;	/* ignore wrong type */

	path = make_devpath(opp,"resource");
	if (SYSFS_VALUE16_WAIT(path,&dummy,3,opp->msg_level) == INVALID)
		return INVALID;

	return GOOD;
}

int
get_sysfs_class(mu_op_t *opp)
{
	char *path;
	unsigned int value;
	MU_pci_config_t *config;

	config = opp->config;

	path = make_devpath(opp,"class");
	if (SYSFS_VALUE16(path,&value,opp->msg_level) == INVALID)
		return INVALID;
	config->class = value;	
	config->class_mask = 0;	/* not used */
	LOG_OPP_DESC("class 0x%x",config->class);

	return GOOD;
}

int
get_sysfs_vendor(struct mu_op *opp)
{
	char *path;
	unsigned int value;
	MU_pci_config_t *config;

	config = opp->config;

	/* vendor */
	path = make_devpath(opp,"vendor");
	if (SYSFS_VALUE16(path,&value,opp->msg_level) == INVALID)
		return INVALID;
	config->id.vendor = value;	
	LOG_OPP_DESC("vendor 0x%x",config->id.vendor);

	/* subsystem_vendor */
	path = make_devpath(opp,"subsystem_vendor");
	if (SYSFS_VALUE16(path,&value,opp->msg_level) == INVALID)
		return INVALID;
	config->sub_id.vendor = value;	
	LOG_OPP_DESC("sybsystem_vendor 0x%x",config->sub_id.vendor);

	return GOOD;
}

int
get_sysfs_device(struct mu_op *opp)
{
	char *path;
	unsigned int value;
	MU_pci_config_t *config;

	config = opp->config;

	/* device */
	path = make_devpath(opp,"device");
	if (SYSFS_VALUE16(path,&value,opp->msg_level) == INVALID)
		return INVALID;
	config->id.device = value;	
	LOG_OPP_DESC("device 0x%x",config->id.device);

	/* subsystem_device */
	path = make_devpath(opp,"subsystem_device");
	if (SYSFS_VALUE16(path,&value,opp->msg_level) == INVALID)
		return INVALID;
	config->sub_id.device = value;	
	LOG_OPP_DESC("sybsystem_device 0x%x",config->sub_id.device);

	return GOOD;
}
