/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: card.c,v 1.5 2004/09/12 08:07:40 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<string.h>
#include	<stdlib.h>
#include	<unistd.h>
#include	<sys/ioctl.h>
#include	<sys/types.h>
#include	<errno.h>

#include	<pcmcia/cs_types.h>
#include	<pcmcia/cs.h>
#include	<pcmcia/cistpl.h>
#include	<pcmcia/ds.h>

#include	"murasaki.h"
#include	"murasaki_pcmcia.h"

static ds_ioctl_arg_t *
get_tuple(int fd,cisdata_t cis,ds_ioctl_arg_t *data)
{
	data->tuple.DesiredTuple = cis;
	data->tuple.Attributes = 0;
	if (ioctl(fd, DS_GET_FIRST_TUPLE, data) != 0)
		return NULL;
	data->tuple.TupleOffset = 0;
	if (ioctl(fd, DS_GET_TUPLE_DATA, data) != 0)
		return NULL;
	if (ioctl(fd, DS_PARSE_TUPLE, data) != 0)
		return NULL;

	return data;
}

/*
 * Manufacturer ID
 * Functional ID
 * Version 1 info
 */
int
get_info_pcmcia(mu_op_t *opp)
{
	int ret;
	ds_ioctl_arg_t data;
	MU_pcmcia_config_t *config;

	config = opp->config;

	/* set config->fd */
	if (make_socket(opp) == INVALID)
		return INVALID;

	ret = ioctl(config->fd,DS_VALIDATE_CIS, &data);

	/* Card does Not have CIS data */
	if (ret != 0 || (data.cisinfo.Chains <= 0)) {
		return INVALID;
	}

	/* Manifucture ID */
	if (get_tuple(config->fd,CISTPL_MANFID,&data) != NULL)
		config->manufacture = data.tuple_parse.parse.manfid;
	/* Version_1 info */
	if (get_tuple(config->fd,CISTPL_VERS_1,&data) != NULL)
		config->version_1 = data.tuple_parse.parse.version_1;
	/* Function ID */
	if (get_tuple(config->fd,CISTPL_FUNCID,&data) != NULL)
		config->function = data.tuple_parse.parse.funcid;
	/* UUM... I don't know why */
	else if (get_tuple(config->fd, CISTPL_DEVICE_GEO, &data) != NULL)
		config->function.func = CISTPL_FUNCID_MEMORY;

	return GOOD;
}

void
binding_module(mu_op_t *opp)
{
	MU_pcmcia_config_t *config;
	bind_info_t bind;
	int i,ret;

	config = opp->config;

	if (opp->module_list.used == 0)
		return;
	strcpy((char *)bind.dev_info,opp->module_list.list[0]);
	/* function number binding of multi-function card is ignored now. */
	bind.function = 0;
	if (opp->action == ACTION_ADD) {
		if (ioctl(config->fd, DS_BIND_REQUEST ,&bind) != 0) {
			LOG_OPP_QUIET("bind failed: %m");
			exit(1);
		}
		for(i = 0;i < 4;i++) {
			ret = ioctl(config->fd,DS_GET_DEVICE_INFO,&bind);
			if ((ret == 0) || (errno != EAGAIN))
				break;
			usleep(500000);
		}
		if (ret != 0) {
			LOG_OPP_QUIET("get device infos failed: %m");
			exit(1);
		}
	} else {	/* ACTION_REMOVE */
		if (ioctl(config->fd, DS_UNBIND_REQUEST ,&bind) != 0) {
			LOG_OPP_QUIET("unbind failed: %m");
			exit(1);
		}
	}
}

