/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: op.c,v 1.5 2004/09/12 08:10:12 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<string.h>
#include	<stdlib.h>

#include	"murasaki.h"
#include	"murasaki_pcmcia.h"

static MU_pcmcia_config_t config;

static void
pre_script(mu_op_t *opp,int timing)
{
	exec_script(opp,timing);
	if (opp->action == ACTION_REMOVE) {
		binding_module(opp);
	}
}

static void
end_script(mu_op_t *opp,int timing)
{
	if (opp->action == ACTION_ADD) {
		binding_module(opp);
	}
	exec_script(opp,timing);
}

struct mu_op mu_op = {
	flag: FLAG_BEEP,
	msg_level: MU_MSG_STD,
	device: pcmcia_socket,
	device_name: MU_ARG_PCMCIA,
	command: MU_MURASAKI "." MU_ARG_PCMCIA,
	mappath: {MU_CONF_DIR "/" MU_PCMCIAMAP,NULL,NULL,NULL},
	action: ACTION_NONE,
	config: &config,
	sysfs: NULL,
	devpath: NULL,

	get_info: get_info_pcmcia,
	get_list: create_modulelist,
	match_map: match_config,
	run: load_module,
	prepare: pre_script,
	end: end_script,
};


