//driver_muroar.c:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2010
 *
 *  This file is part of RoarD,
 *  a sound server daemon for using the RoarAudio protocol.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  or (at your option) any later version as published by
 *  the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#include "muroard.h"
#include <sndio.h>

#define DRIVER_HAVE_INIT
#define DRIVER_HAVE_FREE
#define DRIVER_HAVE_WRITE

struct sio_hdl * driver_sndio_hdl = NULL;

/* TODO: FIXME: this driver needs error handlung! */

int driver_init(char * dev) {
 struct sio_par par;

 sio_initpar(&par);

 par.bits  = 16;
 par.rate  = g_sa_rate;
 par.pchan = g_sa_channels;
 par.le    = SIO_LE_NATIVE;
 par.sig   = 1;

 if ( (driver_sndio_hdl = sio_open(dev, SIO_PLAY, 0)) == NULL )
  return -1;

 if ( sio_setpar(driver_sndio_hdl, &par) == 0 ) {
  sio_close(driver_sndio_hdl);
  return -1;
 }

 if ( sio_start(driver_sndio_hdl) == 0 ) {
  sio_close(driver_sndio_hdl);
  return -1;
 }

 return 0;
}

int driver_free(void) {
 if ( driver_sndio_hdl != NULL ) {
  sio_stop(driver_sndio_hdl);
  sio_close(driver_sndio_hdl);
 }

 return 0;
}

int driver_write(int16_t * data) {
 sio_write(driver_sndio_hdl, data, g_abuffer_size);

 return 0;
}

//ll
