//network.h:

/*
 *      Copyright (C) Philipp 'ph3-der-loewe' Schafft - 2010
 *
 *  This file is part of RoarD,
 *  a sound server daemon for using the RoarAudio protocol.
 *  See README for details.
 *
 *  This file is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 3
 *  or (at your option) any later version as published by
 *  the Free Software Foundation.
 *
 *  RoarAudio is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 */

#ifndef _MUROARD_NETWORK_H_
#define _MUROARD_NETWORK_H_

#define NETWORK_TYPE_UNIX      1
#define NETWORK_TYPE_INET      2

int network_init(void);
int network_free(void);
int network_prefree(void);

int network_listen(int type, char * addr, int port);

int network_nonblock(int fh);

int network_check(void);

#ifdef __WIN32
#define network_read(fh,buf,len)  recv((fh), (buf), (len), 0)
#define network_write(fh,buf,len) send((fh), (buf), (len), 0)
#define network_close(fh)         closesocket((fh))
#else
#define network_read(fh,buf,len)  read((fh), (buf), (len))
#define network_write(fh,buf,len) write((fh), (buf), (len))
#define network_close(fh)         close((fh))
#endif

#ifdef MUROAR_FEATURE_CMD_PASSFH
int network_recvfh(int fh);
#endif

#endif

//ll
