/*
 * Header of the proxy base class for communicating via D-Bus.
 *
 * Music Applet
 * Copyright (C) 2006 Paul Kuliniewicz <paul.kuliniewicz@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02111-1301, USA.
 *
 */

#ifndef MA_DBUS_PROXY_H
#define MA_DBUS_PROXY_H

#include "ma-proxy.h"

#include <dbus/dbus-glib.h>


#define MA_TYPE_DBUS_PROXY		(ma_dbus_proxy_get_type ())
#define MA_DBUS_PROXY(o)		(G_TYPE_CHECK_INSTANCE_CAST ((o), MA_TYPE_DBUS_PROXY, MaDBusProxy))
#define MA_DBUS_PROXY_CLASS(k)		(G_TYPE_CHECK_CLASS_CAST ((k), MA_TYPE_DBUS_PROXY, MaDBusProxyClass))
#define MA_IS_DBUS_PROXY(o)		(G_TYPE_CHECK_INSTANCE_TYPE ((o), MA_TYPE_DBUS_PROXY))
#define MA_IS_DBUS_PROXY_CLASS(k)	(G_TYPE_CHECK_CLASS_TYPE ((k), MA_TYPE_DBUS_PROXY))
#define MA_DBUS_PROXY_GET_CLASS(o)	(G_TYPE_INSTANCE_GET_CLASS ((o), MA_TYPE_DBUS_PROXY, MaDBusProxyClass))

typedef struct _MaDBusProxy		MaDBusProxy;
typedef struct _MaDBusProxyClass	MaDBusProxyClass;

struct _MaDBusProxy
{
	MaProxy parent;
};

struct _MaDBusProxyClass
{
	MaProxyClass parent;

	/*< vtable >*/

	void (*connect) (MaDBusProxy *dproxy, DBusGConnection *connection);
	void (*disconnect) (MaDBusProxy *dproxy);

	/*< private >*/

	DBusGConnection *connection;
	DBusGProxy *bus_proxy;
};

GType	ma_dbus_proxy_get_type (void);

/* The following functions are for subclasses' use only. */

void	_ma_dbus_proxy_launch (MaDBusProxy *dproxy);

void	_ma_dbus_proxy_cancel_call (DBusGProxy *dbus_proxy, DBusGProxyCall **call);
void	_ma_dbus_proxy_report_error (const gchar *method, GError **error);

#endif /* MA_DBUS_PROXY_H */
