/*
 * Header of the fancy tooltip for displaying song information.
 *
 * Music Applet
 * Copyright (C) 2004-2006 Paul Kuliniewicz <paul.kuliniewicz@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02111-1301, USA.
 *
 */

#ifndef MA_SONG_TOOLTIP_H
#define MA_SONG_TOOLTIP_H

#include "ma-proxy.h"

#include <gtk/gtkwidget.h>

#define MA_TYPE_SONG_TOOLTIP		(ma_song_tooltip_get_type ())
#define MA_SONG_TOOLTIP(o)		(G_TYPE_CHECK_INSTANCE_CAST ((o), MA_TYPE_SONG_TOOLTIP, MaSongTooltip))
#define MA_SONG_TOOLTIP_CLASS(k)	(G_TYPE_CHECK_CLASS_CAST ((k), MA_TYPE_SONG_TOOLTIP, MaSongTooltipClass))
#define MA_IS_SONG_TOOLTIP(o)		(G_TYPE_CHECK_INSTANCE_TYPE ((o), MA_TYPE_SONG_TOOLTIP))
#define MA_IS_SONG_TOOLTIP_CLASS(k)	(G_TYPE_CHECK_CLASS_TYPE ((k), MA_TYPE_SONG_TOOLTIP))
#define MA_SONG_TOOLTIP_GET_CLASS(o)	(G_TYPE_INSTANCE_GET_CLASS ((o), MA_TYPE_SONG_TOOLTIP, MaSongTooltipClass))

typedef struct _MaSongTooltip		MaSongTooltip;
typedef struct _MaSongTooltipClass	MaSongTooltipClass;

struct _MaSongTooltip
{
	GObject parent;
};

struct _MaSongTooltipClass
{
	GObjectClass parent_class;
};

GType		ma_song_tooltip_get_type (void);

MaSongTooltip *	ma_song_tooltip_new (MaProxy *proxy);

void		ma_song_tooltip_attach (MaSongTooltip *tip, GtkWidget *owner);

#endif /* MA_SONG_TOOLTIP_H */
