/***************************************************************************
 Mutella - A commandline/HTTP client for the Gnutella filesharing network.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 readline4fix.c  -  wrapper/helper functions for the readline library.

    begin                : Mon Oct 8 2001
    copyright            : (C) 2001 by 
    email                : maksik@gmx.co.uk
 ***************************************************************************/
 
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <readline/readline.h>
#include <readline/history.h>

#include "readline4fix.h"

char * readline_fix(const char *prompt)
{
	return readline((char *) prompt);
}

void add_history_fix(const char *item)
{
	add_history((char *) item);
}

char** rl_completion_matches_fix(const char * text, char* (*generator_func)(const char *text, int state))
{
#ifdef HAVE_READLINE_42
	return rl_completion_matches(text, generator_func);
#else /*HAVE_READLINE_42*/
	return NULL;
#endif /*HAVE_READLINE_42*/
}

void rl_readline_name_fix(const char* name)
{
	rl_readline_name = name;
}

void rl_attempted_completion_function_fix(char** (*compl_func)(const char *text, int start, int end))
{
	rl_attempted_completion_function = compl_func;
}

const char * rl_line_buffer_fix()
{
	return rl_line_buffer;
}

void rl_attempted_completion_over_fix()
{
	rl_attempted_completion_over = 1;
}

void rl_complete_show_all_fix(int n)
{
	rl_variable_bind("show-all-if-ambiguous", n ? "1" : "0");
}

#ifdef HAVE_READLINE_42

void rl_get_screen_size_fix(int *rows, int *cols)
{
	rl_get_screen_size(rows, cols);
}

#endif /*HAVE_READLINE_42*/
