// requester.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// Requester is the generic base class for all routines that query the user
// for parameters needed to configure an operation of some sort.  Its virtual
// methods are redefined in a large variety of ways in the large subclass
// heirarchy.  See request.h and query.h for more information.

#ifndef REQUESTER_H
#ifdef __GNUG__
#pragma interface
#endif
#define REQUESTER_H

#include "localdefs.h"

class Controller;
class Request;
class RequestDelegate;
struct QueryInfo;

class Requester {
	friend class RequestDelegate;
public:
	Requester() {}
	virtual ~Requester() {}
	virtual boolean queryForValues(Controller *);
	enum ChoiceReturn { False = 1, True = 2 };
protected:
	virtual const char* requestTitle() { return nil; }
	virtual const QueryInfo *requestInfo() { return nil; }
	virtual RequestDelegate* createDelegate();
	virtual Request* createRequest();
	virtual void configureRequest(Request *) = 0;
	virtual boolean confirmValues() { return true; }
};

class TitledRequester : virtual public Requester {
public:
	TitledRequester(const char* title=nil);
protected:
	virtual const char* requestTitle() { return theTitle; }
private:
	const char* theTitle;
};

#endif
