<?
//    MyDMS. Document Management System
//    Copyright (C) 2002-2005  Markus Westphal
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

/**********************************************************************\
|                 statische, Group-bezogene Funktionen                 |
\**********************************************************************/


function getGroup($id)
{
	GLOBAL $db;
	
	if (!is_numeric($id))
		die ("invalid groupid");
	
	$queryStr = "SELECT * FROM tblGroups WHERE id = " . $id;
	$resArr = $db->getResultArray($queryStr);
	
	if (is_bool($resArr) && $resArr == false)
		return false;
	else if (count($resArr) != 1) //wenn, dann wohl eher 0 als > 1 ;-)
		return false;
	
	$resArr = $resArr[0];
	
	return new Group($resArr["id"], $resArr["name"], $resArr["comment"]);
}


function getAllGroups()
{
	GLOBAL $db;
	
	$queryStr = "SELECT * FROM tblGroups ORDER BY name";
	$resArr = $db->getResultArray($queryStr);
	
	if (is_bool($resArr) && $resArr == false)
		return false;
	
	$groups = array();
	
	for ($i = 0; $i < count($resArr); $i++)
		$groups[$i] = new Group($resArr[$i]["id"], $resArr[$i]["name"], $resArr[$i]["comment"]);
	
	return $groups;
}


function addGroup($name, $comment)
{
	GLOBAl $db;
	
	$queryStr = "INSERT INTO tblGroups (name, comment) VALUES ('".$name."', '" . $comment . "')";
	if (!$db->getResult($queryStr))
		return false;
	
	return getGroup($db->getInsertID());
}


/**********************************************************************\
|                           Group-Klasse                               |
\**********************************************************************/

class Group
{
	var $_id;
	var $_name;

	function Group($id, $name, $comment)
	{
		$this->_id = $id;
		$this->_name = $name;
		$this->_comment = $comment;
	}

	function getID() { return $this->_id; }

	function getName() { return $this->_name; }

	function setName($newName)
	{
		GLOBAL $db;
		
		$queryStr = "UPDATE tblGroups SET name = '" . $newName . "' WHERE id = " . $this->_id;
		if (!$db->getResult($queryStr))
			return false;
		
		$this->_name = $newName;
		return true;
	}

	function getComment() { return $this->_comment; }

	function setComment($newComment)
	{
		GLOBAL $db;
		
		$queryStr = "UPDATE tblGroups SET comment = '" . $newComment . "' WHERE id = " . $this->_id;
		if (!$db->getResult($queryStr))
			return false;
		
		$this->_comment = $newComment;
		return true;
	}

	function getUsers()
	{
		GLOBAL $db;
		
		if (!isset($this->_users))
		{
			$queryStr = "SELECT userID FROM tblGroupMembers WHERE groupID = " . $this->_id;
			$resArr = $db->getResultArray($queryStr);
			if (is_bool($resArr) && $resArr == false)
				return false;
			
			$this->_users = array();
			
			foreach ($resArr as $row)
			{
				$user = getUser($row["userID"]);
				if (is_bool($user) && $user == false)
					return false;
				array_push($this->_users, $user);
			}
		}
		return $this->_users;
	}

	function addUser($user)
	{
		GLOBAL $db;
		
		$queryStr = "INSERT INTO tblGroupMembers (groupID, userID) VALUES (".$this->_id.", ".$user->getID().")";
		$res = $db->getResult($queryStr);
		if ($res)
			return false;
		
		unset($this->_users);
		return true;
	}

	function removeUser($user)
	{
		GLOBAL $db;
		
		$queryStr = "DELETE FROM tblGroupMembers WHERE  groupID = ".$this->_id." AND userID = ".$user->getID();
		$res = $db->getResult($queryStr);
		if ($res)
			return false;
		
		unset($this->_users);
		return true;
	}

	function isMember($user)
	{
		//Wenn die User bereits abgefragt wurden, geht's so schneller:
		if (isset($this->_users))
		{
			foreach ($this->_users as $usr)
				if ($usr->getID() == $user->getID())
					return true;
			return false;
		}
		
		//Ansonsten: DB-Abfrage
		GLOBAL $db;
		$queryStr = "SELECT id FROM tblGroupMembers WHERE groupID = " . $this->_id . " AND userID = " . $user->getID();
		$resArr = $db->getResultArray($queryStr);
		if (is_bool($resArr) && $resArr == false)
			return false;
		
		if (count($resArr) != 1)
			return false;
		else
			return true;
	}

	/**
	 * Entfernt die Gruppe aus dem System.
	 * Dies ist jedoch nicht mit einem Lschen des entsprechenden Eintrags aus tblGroups geschehen - vielmehr
	 * muss dafr gesorgt werden, dass die Gruppe nirgendwo mehr auftaucht. D.h. auch die Tabellen tblACLs,
	 * tblNotify und tblGroupMembers mssen bercksichtigt werden.
	 */
	function remove()
	{
		GLOBAl $db;
		
		$queryStr = "DELETE FROM tblGroups WHERE id = " . $this->_id;
		if (!$db->getResult($queryStr))
			return false;
		$queryStr = "DELETE FROM tblGroupMembers WHERE groupID = " . $this->_id;
		if (!$db->getResult($queryStr))
			return false;
		$queryStr = "DELETE FROM tblACLs WHERE groupID = " . $this->_id;
		if (!$db->getResult($queryStr))
			return false;
		$queryStr = "DELETE FROM tblNotify WHERE groupID = " . $this->_id;
		if (!$db->getResult($queryStr))
			return false;
		
		return true;
	}
}


?>
