#!/bin/sh
if [ -d conf -a -d data ]; then
	MYBASE="."
else 
	MYBASE=".."
fi

MYCONF="$MYBASE/conf/mysource.conf"
BACKUPDIR="$MYBASE/backup"
NOW=`date +'%Y-%d-%m-%H-%M-%S'`

if [ ! -f $MYCONF ]; then
	echo "$MYCONF doesn't exist, it appears as if mysource hasnt been installed"
	exit 1
fi

if [ ! -d "$MYBASE/data" ]; then
	echo "Data directory doesn't exist, it appears as if mysoruce hasn't been installed"
	exit 1
fi

if [ ! -d $BACKUPDIR ]; then
	echo "$BACKUPDIR doesn't exist, creating";
	mkdir -p $BACKUPDIR
fi

mkdir $BACKUPDIR/$NOW

WebDB=`cat $MYCONF | grep 'WebDatabase' | awk '{ print $2 }'`
WebDBHost=`cat $MYCONF | grep 'WebDatabase' | awk '{ print $3 }'`
WebDBUser=`cat $MYCONF | grep 'WebDatabase' | awk '{ print $4 }'`
WebDBPass=`cat $MYCONF | grep 'WebDatabase' | awk '{ print $5 }'`

UserDB=`cat $MYCONF | grep 'UserDatabase' | awk '{ print $2 }'`
UserDBHost=`cat $MYCONF | grep 'UserDatabase' | awk '{ print $3 }'`
UserDBUser=`cat $MYCONF | grep 'UserDatabase' | awk '{ print $4 }'`
UserDBPass=`cat $MYCONF | grep 'UserDatabase' | awk '{ print $5 }'`

# Backup the data directory
if cp -a $MYBASE/data $BACKUPDIR/$NOW; then
	echo 'Data directory backed up';
else 
	echo 'Data directory NOT backed up';
fi

# Backup the mysoruce config
if cp -a $MYCONF $BACKUPDIR/$NOW; then
	echo 'MySource Config backed up';
else 
	echo 'MySource Config NOT backed up';
fi

# Backup the web db
if [ -z $WebDBPass ]; then
	mysqldump --complete-insert --add-drop-table \
	--host=$WebDBHost \
	--user=$WebDBUser \
	$WebDB > $BACKUPDIR/$NOW/backup-web.sql
else 
	mysqldump --complete-insert --add-drop-table \
	--host=$WebDBHost \
	--user=$WebDBUser \
	--password=$WebDBPass \
	$WebDB > $BACKUPDIR/$NOW/backup-web.sql
fi

# Backup the user db
if [ -z $UserDBPass  ]; then
	mysqldump --complete-insert --add-drop-table \
	--host=$UserDBHost \
	--user=$UserDBUser \
	$UserDB > $BACKUPDIR/$NOW/backup-user.sql
else 
	mysqldump --complete-insert --add-drop-table \
	--host=$UserDBHost \
	--user=$UserDBUser \
	--password=$UserDBPass \
	$UserDB > $BACKUPDIR/$NOW/backup-user.sql
fi

(cd $BACKUPDIR ; tar -czf backup-$NOW.tar.gz $NOW);
rm -rf $BACKUPDIR/$NOW
