<?  ##############################################
   ### SquizLib ------------------------------###
  ##- Include Files ------ PHP4 --------------##
 #-- Copyright Squiz.net ---------------------#
##############################################
## This file is subject to version 1.0 of the
## MySource License, that is bundled with
## this package in the file LICENSE, and is
## available at through the world-wide-web at
## http://mysource.squiz.net/
## If you did not receive a copy of the MySource
## license and are unable to obtain it through
## the world-wide-web, please contact us at
## mysource@squiz.net so we can mail you a copy
## immediately.
##
## File: cache/cache.inc
## Desc: A class that manages caching objects.
## $Source: /home/cvsroot/squizlib/cache/cacheableobject.inc,v $
## $Revision: 2.2.2.1 $
## $Author: htdocs $
## $Date: 2002/12/19 04:54:14 $
#######################################################################
# This class assumes a global variable $CACHE has been established
# and is an object of the class "cache".
#---------------------------------------------------------------------#


 ##################################################################
# A special inherible class of objects which can cache themselves.
class CacheableObject extends Object {

	var $id; # Used to distinguish an object from others of its class
	var $cached = array();

	 #################
	# Check the cache
	function load_from_cache($id) {
#		pre_echo("id: $id");
		if (!isset($id)) $id = $this->id;
#		pre_echo("id after: $id");
		#if(!$this->cached[$id]) return false;
		global $CACHE;
		if(!$CACHE || get_parent_class($CACHE) != "cache") {
			$this->_set_error("Can't find global \$CACHE object!",__FILE__,__LINE__);
			return false;
		}
		if($object = $CACHE->read($id,get_class($this))) {
			if (get_class($object) == get_class($this)) {
				$this = $object;
				return true;
			} else {
				$this->_set_error("Attempt to load ".get_class($this)." ($id) yielded something weird from the cache:" .get_class($object),__FILE__,__LINE__);
				return false;
			}
		}
	}

	 ######################
	# Saves to the cache
	function save_to_cache($id='') {
//		array_contents($this,2); # Why? I don't KNOW why. But it fixes inexplicable seg faults in (amoung others) xtras/web/extensions/ecommerce/xtras/data/import/simple (creating new categories during import) and /xtras/web/extensions/ecommerce/attribute_type.inc (saving the parameter set).. anyone who can find a better way to do this is welcome to implement it
		if (!isset($id)) $id = $this->id;
		global $CACHE;
		if(!$CACHE || get_parent_class($CACHE) != "cache") {
			$this->_set_error("Can't find global \$CACHE object!",__FILE__,__LINE__);
			return false;
		}
		$this->cached[$id] = true;
		if($CACHE->write($this,$id,get_class($this))) {
			return true;
		}
		$this->cached[$id] = false;
		return false;
	}


	 ######################
	# Saves to the cache
	function clear_cache($id) {
		if(!isset($id)) $id = $this->id;
		if(isset($this->cached[$id]) && !$this->cached[$id]) return true;
		global $CACHE;
		if(!$CACHE || get_parent_class($CACHE) != "cache") {
			$this->_set_error("Can't find global \$CACHE object!",__FILE__,__LINE__);
			return false;
		}
		if($CACHE->clear($id,get_class($this))) {
			$this->cached[$id] = false;
			return true;
		}
		return false;
	}

	 ######################################
	# Returns the timestamp of the cache
	function get_cache_timestamp ($id) {
		if (!isset($id)) $id = $this->id;
		global $CACHE;
		return $CACHE->timestamp($id, get_class($this));
	}
}

?>