<?  ##############################################
   ### MySource ------------------------------###
  ##- Include Files ------ PHP4 --------------##
 #-- Copyright Squiz.net ---------------------#
##############################################
## File: xtras/page/templates/squiz_imb/squiz_imb.inc
## Desc: A template wich presents a discussion board
## $Source: /home/cvsroot/xtras/page/templates/forbidden/forbidden.inc,v $
## $Revision: 1.3.2.2 $
## $Author: dchong $
## $Date: 2003/01/13 05:45:48 $
#######################################################################
global $INCLUDE_PATH, $SQUIZLIB_PATH;
include_once("$INCLUDE_PATH/page_template.inc");
include_once("$INCLUDE_PATH/parameter_set.inc");
include_once("$INCLUDE_PATH/html_body_format.inc");
include_once("$SQUIZLIB_PATH/bodycopy/bodycopy.inc");
include_once("$SQUIZLIB_PATH/form/form.inc");
#---------------------------------------------------------------------#


class Page_Template_Forbidden extends Page_Template {

	 ##############################################################
	# Lots of interesting options and stuff!
	var $parameters = array();

	 ##############################
	# Constructor
	function Page_Template_Forbidden($pageid) {
		return Page_Template::Page_Template($pageid);
	}


	 ######################################################################
	# Create a new record in the databse and load it into this object
	function create($pageid) {
		global $SESSION;
		$message = Page_Template::create($pageid);
		if(!$this->id)	return false;
		$db = &$this->get_db();
		# Set the title to the title of the current page.
		$page = &$this->get_page($pageid);

		$db->update("UPDATE $this->table_name SET parameters='".addslashes(serialize(array()))."' WHERE pageid='$pageid'");
		$id = $this->load($pageid);
		return $message;
	}



	 ################################################
	# Loads the temaplte details, from cache or database
	function load($pageid) {
		if ($pageid <= 0 && !($pageid = $this->id)) { # Tries "re"loading
			$this->_set_error("Attempt to load $this->name page template without a valid pageid.",__FILE__,__LINE__);
		}

		 #################
		# Check the cache 
		if ($this->load_from_cache($pageid)) return $pageid;

		 ########################
		# Load from the database
		$db = &$this->get_db();
		list($this->id, $tmp) = $db->single_row("SELECT pageid, parameters FROM $this->table_name WHERE pageid='$pageid'");
		$this->parameters = unserialize($tmp);


		 #####################################
		# Create a new record if none exists
		if (!$this->id) {
			return $this->create($pageid);
		}

		$this->set_generated_information();

		 ###################
		# Save to the cache 
		$this->save_to_cache($pageid);
		return $pageid;
	}

	
	 #########################################
	# Grabs a user record from the user system
	function &get_user($userid) {
		$user_system = &get_users_system();
		return $user_system->get_user($userid);
	}


	 #############
	# Duplicating
	function dupe($new_pageid) {
		return Page_Template::dupe($new_pageid);
	}

	 ###################
	# CHanging the ID
	function newid($new_pageid) {
		return Page_Template::newid($new_pageid);
	}

	 ###################
	# Deleting the page
	function delete() {
		return Page_Template::delete();
	}


	 ##################################################
	# Grabs keywords out of the title and bodycopy etc
	function extract_keywords() {
		$db = &$this->get_db();
		foreach($this->parameters[copy] as $code => $bit) {
			if(substr(stripslashes($bit),0,14) == 'O:8:"bodycopy"') {
				$bodycopy = new BodyCopy($bit, $code);
				$copy .= strip_tags_padded($bodycopy->get_html())." ";
			} else $copy .= "$bit ";
		}
		#$copy_keywords $bodycopy->get_html()
		return $this->parameters[title]." ".$copy;
	}

	 ################################
	# Just verifies an option is set
	function check_bool($code,$parameter) {
		return in_array($code,$this->parameters[$parameter]);
	}

	 #####################################
	# grabs the value for a valued option
	function &get_value($code) {
		return $this->parameters[$code];
	}

	 ######################################
	# Sets a parameter value
	function set_value($code,$value) {
		$this->parameters[$code] = $value;
		$this->save_parameters();
	}
	 
	 ######################################################
	# Returns an associaive array of universal replacements
	# These can be used to replace special keywords in copy
	function &get_universal_replacements($descs) {
		global $SESSION;
		$k = &Page_Template::get_universal_replacements();
		$d = &Page_Template::get_universal_replacements(1);
			
		if (!$l = $SESSION->user->login) $l = $SESSION->recall_login();
		$d[username_input] = "Username input box";
		$k[username_input] = "<input type=text name='mysource_login' value='$l' size=".$this->get_value('username_input_size')." maxlength=64 onfocus='javascript: this.select();'>";

		$d[password_input]  = "Password input box";
		$k[password_input]  = "<input type=password name='mysource_password' value='' size=".$this->get_value('password_input_size')." maxlength=64 onfocus='javascript: this.select();'>";

		$d[login_button] = "Login button";
		$k[login_button] = "<input type=button value='".$this->get_value('login_label')."' onclick='if (form.mysource_login.value.length > 0 && form.mysource_password.value.length > 1)form.submit();'>";

		$d[logout_button] = "Logout button";
		$k[logout_button] = "<input type=submit value='".$this->get_value('logout_label')."'>";

		$d[access_reject_message] = "Access reject message (will be preceded by the access reject label)";

		$url_info = $this->web_system->get_url_info($this->web_system->current_url());
		if($url_info[p] != $this->id) {
			global $ACCESS_REJECT_MESSAGE;
			$secure_page = &$this->get_page($url_info[p]);
			$secure_page->read_access();
			$access_reject_message = $ACCESS_REJECT_MESSAGE;
		}
		$k[access_reject_message] = (($ACCESS_REJECT_MESSAGE)?$this->get_value('access_reject_label').' '.$ACCESS_REJECT_MESSAGE:'');

		$d[session_message] = "Session message (will be preceded by the session message label)";
		$k[session_message] = (($SESSION->message())?$this->get_value('session_message_label').' '.$SESSION->message():'');

		if($descs) return $d;
		return $k;
	}

	 #####################################################
	# Saves the current parameter array into the database
	function save_parameters() {
		$this->parameters["__type__"]    = $this->table_name;
		$this->parameters["__version__"] = $this->version;
		$db = &$this->get_db();
		return $db->update("UPDATE $this->table_name SET parameters='".addslashes(serialize($this->parameters))."' WHERE pageid='$this->id'");
		$this->updated();
	}

	 ##################################################################
	# Prints the backend for the user - usually completely overwritten
	function print_backend() {
		$backend = &$this->setup_backend();

		$pset = &$this->get_pset();
		$pset->set_tabs($backend,"template_screen", $this->get_backend_href());
		if($pset->process($backend)) {
			$this->save_parameters();
		}
		$pset->print_backend($backend);

	}

	 ###########################################################
	# Returns the title as it should be printed on the frontend
	function get_title() {
		return $this->get_value("title");
	}

	 #########################################################
	# Don't moderate caching on this page. Use PHP default
	function moderate_caching() {
		return false;
	}

	 ###########################################################################
	# This is where the REAL frontend happens. We like to be in the right scope
	function print_body() {
		global $SESSION,$QUERY_STRING, $_POST;
		$page = &$this->get_page();
		if(!$SESSION->logged_in()) {
			?>
			<form action="<? echo $_SERVER['PHP_SELF'].(($QUERY_STRING)?"?".ereg_replace("[\&]?mysource_session_action=[^\&]+","",$QUERY_STRING):"") ?>" name=login_prompt method=post>
			<input type=hidden name=mysource_login_key value="<?=$SESSION->new_login_key()?>">
				<input type=hidden name=mysource_session_action value="login">
			<?
			 ######################################################################################
			# Take all the post vars and whack em in the form - important ones will get overwitten
			unset($_POST['mysource_login']);
			unset($_POST['mysource_password']);
			unset($_POST['mysource_login_key']);
			unset($_POST['mysource_login_referer']);
			unset($_POST['mysource_session_action']);
			echo var_to_hidden_field("",$_POST,1);
			$bodycopy = new BodyCopy($this->parameters[login_invite]);
			$bodycopy->add_replace_keywords($this->get_universal_replacements());
			$bodycopy->paint();
			?>
			</form>
			<?
		} else {
			?>
			<form action="<? echo $_SERVER['PHP_SELF'].(($QUERY_STRING)?"?".ereg_replace("[\&]?mysource_session_action=[^\&]+","",$QUERY_STRING):"") ?>" method=post>
			<input type=hidden name=mysource_session_action value="logout">
			<?
			$bodycopy = new BodyCopy($this->parameters[logged_in]);
			$bodycopy->add_replace_keywords($this->get_universal_replacements());
			$bodycopy->paint();
			?>
			</form>
			<?
		}
	}
}

?>