<?  ##############################################
   ### MySource ------------------------------###
  ##- Include Files ------ PHP4 --------------##
 #-- Copyright Squiz.net ---------------------#
##############################################
## This file is subject to version 1.0 of the
## MySource License, that is bundled with
## this package in the file LICENSE, and is
## available at through the world-wide-web at
## http://mysource.squiz.net/
## If you did not receive a copy of the MySource
## license and are unable to obtain it through
## the world-wide-web, please contact us at
## mysource@squiz.net so we can mail you a copy
## immediately.
##
## File: xtras/page/templates/redirect/redirect.inc
## Desc: A page template class.. a page which redirects to another page, site, or url
## $Source: /home/cvsroot/xtras/page/templates/redirect/redirect.inc,v $
## $Revision: 2.5.2.2 $
## $Author: bvial $
## $Date: 2002/12/06 05:34:58 $
#######################################################################
global $INCLUDE_PATH;
include_once("$INCLUDE_PATH/page_template.inc");
#---------------------------------------------------------------------#

# Shoved in here so this old template works inthe new system
class Page_Template_Redirect extends Page_Template {

	 ##############################################################
	# A few variables used by this object
	var $to_pageid;
	var $to_url;
	var $new_window;
	var $to_siteid; # Not stored in database
	var $window_options;

	 ##############################
	# Constructor
	function Page_Template_Redirect($pageid, &$system) {
		return Page_Template::Page_Template($pageid, &$system);
	}

	 ######################################################################
	# Create a new record in the databse and load it into this object
	function create($pageid) {
		$message = Page_Template::create($pageid);
		if(!$this->id)	return false;
		$db = &$this->get_db();
		# Set the to_pageid to the index page of the current site
		$site = &$this->get_site();
		$db->update("UPDATE $this->table_name SET to_pageid='$site->index_pageid' WHERE pageid='$pageid'");
		$id = $this->load($pageid);
		return $message;
	}

	 ################################################
	# Loads the temaplte details, from cache or database
	function load($pageid) {
		if ($pageid <= 0 && !($pageid = $this->id)) { # Tries "re"loading
			$this->_set_error("Attempt to load $this->name page template without a valid pageid.",__FILE__,__LINE__);
		}

		 #################
		# Check the cache 
		if ($this->load_from_cache($pageid)) return $pageid;


		 #################################################
		# Load from the database - not everything though 
		$db = &$this->get_db();
		list($this->id,$this->to_pageid,$this->to_url,$this->new_window,$window_options) = $db->single_row("SELECT pageid, to_pageid, to_url, new_window, window_options FROM $this->table_name WHERE pageid='$pageid'");

		$this->window_options = unserialize($window_options);

		 #####################################
		# Create a new record if none exists
		if (!$this->id) {
			return $this->create($pageid);
		}

		$this->set_generated_information();

		 ###################
		# Save to the cache 
		$this->save_to_cache($pageid);
		return $pageid;
	}

	 ##################################################
	# Grabs keywords out of the title and bodycopy etc
	/**
	* Grabs the keywords out of the contents.
	*
	* if the page is redirecting to an external URL, the page is buffered and keywords extracted
	* from that. If the page is redirecting to another MySource page, then it uses that page's
	* extract keywords function to get keywords. 
	*
	* @access public
	* @returns string
	*/
	function extract_keywords() {
		if($this->to_url) {
			ob_start();
			readfile("$this->to_url/");
			$html = ob_get_contents();
			ob_end_clean();
			return strip_tags_padded($html);
		} else { # Recrusion ! (potentially)
			global $REDIRECT_KEYWORD_EXTRACTING_PAGEIDS;
			if ($REDIRECT_KEYWORD_EXTRACTING_PAGEIDS[$this->id]) return ''; # Recursion prevention
			$REDIRECT_KEYWORD_EXTRACTING_PAGEIDS[$this->id] = 1;
			$page     = &$this->get_page($this->to_pageid);
			if(!$page->id) return ''; #no page exists, no keywords
			$template = &$page->get_template();
			return $template->extract_keywords();
		}
	}

	 
	 #################################
	# Change the to_pageid of the page
	function set_to_pageid($to_pageid) {
        if ($to_pageid == $this->to_pageid || $to_pageid == $this->id) return "";   
		$db = &$this->get_db();

		 ######################################
		# Find any pages that redirect to  us.
		$new_to_page = &$this->get_page($to_pageid);
		$page = &$this->get_page();
		if($new_to_page->template == $page->template) {
			$loop = array();
			$pullerids = array($this->id);
			while(count($pullerids = &$db->single_column("SELECT pageid FROM $this->table_name WHERE to_pageid IN (".implode("','",$pullerids).") AND pageid != to_pageid"))) {
				$loop = array_merge($loop, $pullerids);
			}
			$template = &$new_to_page->get_template();
			if($template->check_redirect_loop($loop)) {
				return "Sorry, redirecting to this page would create an infinite redirecting loop which could rupture the very fabric of existance itself.";
			}
		}

        $this->to_pageid = $to_pageid;
        if ($db->update("UPDATE $this->table_name SET to_pageid='$this->to_pageid' WHERE pageid='$this->id'"))  {
			$this->clear_cache();
            return "Redirect page updated.";
        } else {
			return "";
		}
	}

	 ######################################################
	# Checks for a redirectloop, return true of one is detected
	function check_redirect_loop($loop) {
		if(in_array($this->to_pageid,$loop)) return true;
		$topage = &$this->get_page($this->to_pageid);
		$page = &$this->get_page();
		if($topage->id && $topage->template == $page->template) {
			$loop[] = $this->id;
			$template = &$topage->get_template();
			if($template->check_redirect_loop($loop)) return true;
		}
		return false;
	}
	 
	 ###############################################################
	# Set the to_url
	function set_to_url($to_url) {
        if ($to_url == $this->to_url) return "";   
		$db = &$this->get_db();
        $this->to_url = $to_url;
        if ($db->update("UPDATE $this->table_name SET to_url='".addslashes($this->to_url)."' WHERE pageid='$this->id'"))  {
			$this->clear_cache();
            return "Redirect URL updated.";
        } else {
			return "";
		}
	}

	 ###############################################################
	# Set weather or not this page should pop up in a new window
	function set_new_window($new_window) {
		if ($new_window == $this->new_window) return "";   
		$db = &$this->get_db();
		$this->new_window = $new_window;
		if ($db->update("UPDATE $this->table_name SET new_window='$this->new_window' WHERE pageid='$this->id'"))  {
			$this->clear_cache();
			return "Redirect updated.";
		} else {
			return "";
		}
	}

	 ###############################################################
	# Set weather or not this page should pop up in a new window
	function set_window_options($window_options) {
		if ($window_options == $this->window_options) return "";   
		$db = &$this->get_db();
		$this->window_options = $window_options;
		if ($db->update("UPDATE $this->table_name SET window_options='".addslashes($this->window_options)."' WHERE pageid='$this->id'"))  {
			$this->clear_cache();
			return "Redirect updated.";
		} else {
			return "";
		}
	}

	 ###################################################################
	# A little helper function with returns what site a page belngs to
	function get_siteid($pageid) {
		$db = &$this->get_db();
		return $db->single_element("SELECT siteid FROM page WHERE pageid='$pageid'");
	}

	 ##################################################################
	# Prints the backend for the user 
	function print_backend() {
		global $SESSION;

		$backend = &$this->setup_backend();
		$site = &$this->get_site();
		$page = &$this->get_page();
		$db = &$this->get_db();

		global $action,$to_siteid,$to_pageid,$to_url,$new_window,$scrollbars,$menubar,$location,$status,$toolbar,$personalbar,$width,$height,$resizable,$directories;
		switch($action) {
		case "Commit":
			$backend->add_message($this->set_to_pageid($to_pageid));
			$backend->add_message($this->set_to_url(valid_url(gpc_stripslashes($to_url))));
			$backend->add_message($this->set_new_window($new_window));
			if($this->new_window == 'Y') {
				$backend->add_message($this->set_window_options(serialize(array("scrollbars"=>$scrollbars,"menubar"=>$menubar,"location"=>$location,"status"=>$status,"toolbar"=>$toolbar,"width"=>$width,"height"=>$height,"personalbar"=>$personalbar,"resizable"=>$resizable,"directories"=>$directories))));
			}
			if (((int) $this->to_pageid <= 0 && !$this->to_url)) {
				$new_site = &$this->get_site($to_siteid);
				$this->set_to_pageid($new_site->index_pageid);
			}
			$this->updated();
			break;
		case "New Site":
			$new_site = &$this->get_site($to_siteid);
			$this->set_to_pageid($new_site->index_pageid);
			$this->updated();
			break;
		default:
			break;
		}

		$backend->print_header();		

		$backend->open_section();		
		
		$backend->open_field("Site:");

		$sites = $this->web_system->get_editable_sites($SESSION->user->id);

		$sites[$site->id] = "[THIS SITE] ".$sites[$site->id];

		echo combo_box("to_siteid",$sites,$this->get_siteid($this->to_pageid),"onchange=\"alert('Redirecting to a different site...');form.action.value='New Site';form.submit();\"");

		$backend->open_field("Page:");

		echo combo_box("to_pageid",$this->web_system->page_array_with_sticks($this->get_siteid($this->to_pageid)),$this->to_pageid,"class=data");

		$backend->open_field("or URL:");
		echo text_box("to_url",$this->to_url,50,255);
			
		$backend->open_field("Pop up a new window?:","top");
		echo "<input type=radio name=new_window value=Y ".(($this->new_window == 'Y')?"checked":"").">Yes<br>";
		echo "<input type=radio name=new_window value=N ".(($this->new_window != 'Y')?"checked":"").">No";
	
		if($this->new_window == 'Y') {
			$backend->open_field("Hide","top");
			echo "<input type=checkbox name=location value=1 ".(($this->window_options["location"]) ? "checked" : "").">Location Bar<br>";
			echo "<input type=checkbox name=menubar     value=1 ".(($this->window_options["menubar"])     ? "checked" : "").">Menubar<br>";
			echo "<input type=checkbox name=scrollbars  value=1 ".(($this->window_options["scrollbars"])  ? "checked" : "").">Scrollbars<br>";
			echo "<input type=checkbox name=status   value=1 ".(($this->window_options["status"])   ? "checked" : "").">Status Bar<br>";
			echo "<input type=checkbox name=toolbar     value=1 ".(($this->window_options["toolbar"])     ? "checked" : "").">Tool Bar<br>";
			echo "<input type=checkbox name=resizable   value=1 ".(($this->window_options["resizable"])   ? "checked" : "").">Resizable<br>";
			$backend->open_field("Window Size","top");
			echo text_box("width",$this->window_options["width"],4,4);
			echo "width<br>";
			echo text_box("height",$this->window_options["height"],4,4);
			echo "height<br>";

		}

        $backend->print_commit_button("Commit","document.edit.action.value='Commit';document.edit.submit();");

		$backend->print_footer();		
	}

	 ################################################
	# Prints or does various things on the front-end
	function print_frontend() {

		$page = &$this->get_page();
		$site = &$this->get_site();
		$db = &$this->get_db();

		if($this->to_url) { # Go to external URL
			$location = valid_url($this->to_url);
		} elseif ((int) $this->to_pageid) { # GO to another page in the system
			$site_index = &$site->get_page_index();
			if(isset($site_index[$this->to_pageid])) {
				$location = $this->web_system->get_page_url($site->id,(int)$this->to_pageid); 
			} else {
				$db = &$this->get_db();
				$siteid = $db->single_element("SELECT siteid FROM page WHERE pageid='$this->to_pageid'");
				$location = $this->web_system->get_page_url($siteid,(int)$this->to_pageid); 
			}
		}

		if (!$location) $location = $this->web_system->get_site_url($site->id); 

		#echo $location;exit();

		if ($this->new_window == 'Y') {
			echo "<html><body><script language=javascript>";
			echo "page = window.open('".$location."','".time()."','toolbar=".(($this->window_options[toolbar])?"0":"1").",menubar=".(($this->window_options[menubar])?"0":"1").",location=".(($this->window_options[location])?"0":"1").",status=".(($this->window_options[status])?"0":"1").",scrollbars=".(($this->window_options[scrollbars])?"0":"1").",resizable=".(($this->window_options[resizable])?"0":"1").(($this->window_options[width])?",width=".$this->window_options[width]:"").(($this->window_options[height])?",height=".$this->window_options[height]:"")."');";
			echo("history.go(-1);");
			echo "</script></body></html>";
		} else {
			header("Location: $location");
		}		
	
	}

	 ################################################
	# Prints the "body" of a page.. the main section
	function print_body() {
		echo "<p>This page is a redirect template. It does not have any body copy.</p>";
	}


}

?>
