<?  ##############################################
   ### MySource ------------------------------###
  ##- Include Files ------ PHP4 --------------##
 #-- Copyright Squiz.net ---------------------#
##############################################
## This file is subject to version 1.0 of the
## MySource License, that is bundled with
## this package in the file LICENSE, and is
## available at through the world-wide-web at
## http://mysource.squiz.net/
## If you did not receive a copy of the MySource
## license and are unable to obtain it through
## the world-wide-web, please contact us at
## mysource@squiz.net so we can mail you a copy
## immediately.
##
## Desc: An extension to the standard page, this lists subpages as well.
## $Source: /home/cvsroot/xtras/page/templates/sub_page/sub_page.inc,v $
## $Revision: 1.17.2.5 $
## $Author: csmith $
## $Date: 2002/12/24 01:04:43 $
#######################################################################
global $INCLUDE_PATH, $SQUIZLIB_PATH;
include_once("$INCLUDE_PATH/page_template.inc");
include_once("$SQUIZLIB_PATH/bodycopy/bodycopy.inc");
#---------------------------------------------------------------------#

class Page_Template_Sub_Page extends Page_Template {

	var $title;
	var $bodycopy;
	var $page_copy;
	var $number_per_row;
	var $number_per_page;
	var $position;
	var $horizontal_divider;
	var $vertical_divider;
	var $link_colour;
	var $user_anchors;
	var $popup_window=array(
						'on' => '', 
						'menu' => '',
						'tool' => '',
						'width' => '',
						'height' => '',
						'resize' => '',
						'status' => '',
						'scroll' => '',
						'location' => ''
		);

	var $_page_copy_keywords = Array(); # cached but not stored

	 ##############################
	# Constructor
	function Page_Template_Sub_Page($pageid) {
		return Page_Template::Page_Template($pageid);
	}

	 ######################################################################
	# Create a new record in the databse and load it into this object
	function create($pageid) {
		$message = Page_Template::create($pageid);
		if(!$this->id)	return false;
		$db = &$this->get_db();
		# Set the title to the title of the current page.
		$page = &$this->get_page($pageid);
		$db->update("UPDATE $this->table_name SET title = '".addslashes($page->name)."' WHERE pageid='$pageid'");
		$id = $this->load($pageid);
		return $message;
	}



	 ################################################
	# Loads the temaplte details, from cache or database
	function load($pageid) {
		if ($pageid <= 0 && !($pageid = $this->id)) { # Tries "re"loading
			$this->_set_error("Attempt to load $this->name page template without a valid pageid.",__FILE__,__LINE__);
		}

		 #################
		# Check the cache 
		if ($this->load_from_cache($pageid)) return $pageid;

		 #################################################
		# Load from the database - not everything though 
		$db = &$this->get_db();
		$sql = "SELECT pageid, title, bodycopy, page_copy, number_per_row, number_per_page, 
						position, horizontal_divider, vertical_divider, link_colour, use_anchors,
						popup_window, popup_window_menu, popup_window_tool, popup_window_width, popup_window_height,
						popup_window_resize, popup_window_status, popup_window_scroll, popup_window_location
				FROM $this->table_name 
				WHERE pageid='$pageid'";
		list(
			$this->id,
			$this->title,
			$this->bodycopy,
			$this->page_copy,
			$this->number_per_row,
			$this->number_per_page,
			$this->position,
			$this->horizontal_divider,
			$this->vertical_divider, 
			$this->link_colour, 
			$this->use_anchors,
			$this->popup_window['on'],
			$this->popup_window['menu'],
			$this->popup_window['tool'],
			$this->popup_window['width'],
			$this->popup_window['height'],
			$this->popup_window['resize'],
			$this->popup_window['status'],
			$this->popup_window['scroll'],
			$this->popup_window['location']
		) = $db->single_row($sql);
		unset($sql);

		 #####################################
		# Create a new record if none exists
		if (!$this->id) {
			return $this->create($pageid);
		}

		$this->set_generated_information();

		$this->set_temp_information();

		 ###################
		# Save to the cache 
		$this->save_to_cache($pageid);
		return $pageid;
	}

	 #######################################################
	# Removes the extension utterly from existance !
	function delete()   {
		$bodycopy = new BodyCopy($this->bodycopy);
		$bodycopy->delete();
		$page_copy = new BodyCopy($this->page_copy);
		$page_copy->delete();
		return Page_Template::delete();
	}

	# dupe and new_id need no change from the default

	 #################################################################################
	# Provides an associative array of data that other templates might like to import
	function export_data() {
		return array('title'=>$this->title,'bodycopy'=>$this->bodycopy);
	}

	 
	 #################################################################################
	# Provides an associative array of data that other templates might like to import
	function import_data(&$data) {
		foreach($data as $code => $datum) {
			$code = strtolower(eregi_replace('[^a-z]+','',$code));
			if ($code == title || $code == name) {
				$this->title = $datum;
			}
			if ($code == bodycopy) {
				$this->bodycopy = $datum;
			}
		}
		$db = &$this->get_db();
		$db->update("UPDATE $this->table_name SET
			title='".addslashes($this->title)."',
			bodycopy='".addslashes($this->bodycopy)."'
			WHERE pageid='$this->id'");

		$this->clear_cache($this->id);
	}


	 ##############################################
	# Grabs keywords out of the title and bodycopy
	function extract_keywords() {
		$bodycopy = new BodyCopy($this->bodycopy, 'bodycopy');
		return $this->title.' '.strip_tags_padded($bodycopy->get_html());
	}


	 #################################
	# Change the title of the page
	function set_title($title) {
        if ($title == $this->title) return '';   
		$db = &$this->get_db();
        $this->title = $title;
        if ($db->update("UPDATE $this->table_name SET title='".addslashes($this->title)."' WHERE pageid='$this->id'"))  {
			$this->clear_cache();
            return array(MYSOURCE_ERROR_CODE_NONE, 'Title Updated.');
        } else {
			return array(MYSOURCE_ERROR_CODE_ERROR, 'Title Not Updated');
		}
	}

	 ###############################################################
	# Set the bodycopy - assumes its all ready to shove in the db
	function set_bodycopy($bodycopy) {
        if ($bodycopy == $this->bodycopy) return '';   
		$db = &$this->get_db();
        $this->bodycopy = $bodycopy;
        if ($db->update("UPDATE $this->table_name SET bodycopy='".addslashes($this->bodycopy)."' WHERE pageid='$this->id'"))  {
			$this->clear_cache();
            return array(MYSOURCE_ERROR_CODE_NONE, 'Bodycopy Updated.');
        } else {
            return array(MYSOURCE_ERROR_CODE_ERROR, 'Bodycopy Not Updated');
		}

	}

	 ###############################################################
	# Set the page_copy - assumes its all ready to shove in the db
	function set_page_copy($page_copy) {
        if ($page_copy == $this->page_copy) return '';   
		$db = &$this->get_db();
        $this->page_copy = $page_copy;
        if ($db->update("UPDATE $this->table_name SET page_copy='".addslashes($this->page_copy)."' WHERE pageid='$this->id'"))  {
			$this->clear_cache();
			$this->set_temp_information();
            return array(MYSOURCE_ERROR_CODE_NONE, 'Page Copy Updated.');
        } else {
            return array(MYSOURCE_ERROR_CODE_ERROR, 'Page Copy Not Updated');
		}

	}

	 #################################
	# Change the number of subpages to display per row
	function set_number_per_row($number_per_row) {
		$number_per_row = abs((int) $number_per_row);
        if ($number_per_row == $this->number_per_row) return '';   
		$db = &$this->get_db();
        $this->number_per_row = $number_per_row;
        if ($db->update("UPDATE $this->table_name SET number_per_row='".$number_per_row."' WHERE pageid='$this->id'"))  {
			$this->clear_cache();
            return array(MYSOURCE_ERROR_CODE_NONE, 'Number per row updated.');
        } else {
			return array(MYSOURCE_ERROR_CODE_ERROR, 'Number per row not updated');
		}
	}


	 #################################
	# Change the number of subpages to display per page
	function set_number_per_page($number_per_page) {
		$number_per_page = abs((int) $number_per_page);
        if ($number_per_page == $this->number_per_page) return '';   
		$db = &$this->get_db();
        $this->number_per_page = $number_per_page;
        if ($db->update("UPDATE $this->table_name SET number_per_page='".$number_per_page."' WHERE pageid='$this->id'"))  {
			$this->clear_cache();
            return array(MYSOURCE_ERROR_CODE_NONE, 'Number per page updated.');
        } else {
			return array(MYSOURCE_ERROR_CODE_ERROR, 'Number per page not updated');
		}
	}

	 #################################
	# Change the position of the listing on the page
	function set_position($position) {
		if ($position != 'a' && $position != 'b' && $position != 'k') return array(MYSOURCE_ERROR_CODE_ERROR, "Position '$position' unknown");
        if ($position == $this->position) return '';
		$db = &$this->get_db();
        $this->position = $position;
        if ($db->update("UPDATE $this->table_name SET position='".$position."' WHERE pageid='$this->id'"))  {
			$this->clear_cache();
            return array(MYSOURCE_ERROR_CODE_NONE, 'Position Updated.');
        } else {
			return array(MYSOURCE_ERROR_CODE_ERROR, 'Position Not Updated');
		}
	}

	 #################################
	# Change the horizontal divider option on the page
	function set_horizontal_divider($horizontal_divider) {
		$horizontal_divider = ($horizontal_divider) ? 1 : 0;
        if ($horizontal_divider == $this->horizontal_divider) return '';   
		$db = &$this->get_db();
        $this->horizontal_divider = $horizontal_divider;
        if ($db->update("UPDATE $this->table_name SET horizontal_divider='".$horizontal_divider."' WHERE pageid='$this->id'"))  {
			$this->clear_cache();
            return array(MYSOURCE_ERROR_CODE_NONE, 'Horizontal Divider updated.');
        } else {
			return array(MYSOURCE_ERROR_CODE_ERROR, 'Horizontal Divider not updated');
		}
	}

	 ##################################################
	# Change the vertical divider option on the page
	function set_vertical_divider($vertical_divider) {
		$vertical_divider = ($vertical_divider) ? 1 : 0;
        if ($vertical_divider == $this->vertical_divider) return '';   
		$db = &$this->get_db();
        $this->vertical_divider = $vertical_divider;
        if ($db->update("UPDATE $this->table_name SET vertical_divider='".$vertical_divider."' WHERE pageid='$this->id'"))  {
			$this->clear_cache();
            return array(MYSOURCE_ERROR_CODE_NONE, 'Vertical Divider updated.');
        } else {
			return array(MYSOURCE_ERROR_CODE_ERROR, 'Vertical Divider not updated');
		}
	}

	 ####################################################################
	# Change the colour of the links that we create for the listings
	function set_link_colour($link_colour) {
        if ($link_colour == $this->link_colour) return '';   
		$db = &$this->get_db();
        $this->link_colour = $link_colour;
        if ($db->update("UPDATE $this->table_name SET link_colour='".$link_colour."' WHERE pageid='$this->id'"))  {
			$this->clear_cache();
            return array(MYSOURCE_ERROR_CODE_NONE, 'Link Colour updated.');
        } else {
			return array(MYSOURCE_ERROR_CODE_ERROR, 'Link Colour not updated');
		}
	}

	 ####################################################################
	# Set whether or not to place an anchor at the top of each listing
	function set_use_anchors($use_anchors) {
		$use_anchors = ($use_anchors) ? 1 : 0;
        if ($use_anchors == $this->use_anchors) return '';
		$db = &$this->get_db();
        $this->use_anchors = $use_anchors;
        if ($db->update("UPDATE $this->table_name SET use_anchors='".$use_anchors."' WHERE pageid='$this->id'"))  {
			$this->clear_cache();
            return array(MYSOURCE_ERROR_CODE_NONE, 'Use Anchors updated.');
        } else {
			return array(MYSOURCE_ERROR_CODE_ERROR, 'Use Anchors not updated');
		}
	}

	 ####################################################################
	# Set whether or not to place an anchor at the top of each listing
	function set_popup_window($popup_window) {
		if (!$popup_window['on']) $popup_window['on'] = 0;
		if (
			$popup_window['on']		== $this->popup_window['on'] &&
			$popup_window['menu']		== $this->popup_window['menu'] &&
			$popup_window['tool']		== $this->popup_window['tool'] &&
			$popup_window['width']		== $this->popup_window['width'] &&
			$popup_window['height']	== $this->popup_window['height'] &&
			$popup_window['resize']	== $this->popup_window['resize'] &&
			$popup_window['status']	== $this->popup_window['status'] &&
			$popup_window['scroll']	== $this->popup_window['scroll'] &&
			$popup_window['location']	== $this->popup_window['location']
			) return;
		$db = &$this->get_db();

		# The reason I'm doing this is so if you turn the new window OFF, you don't lose the rest of the settings.
		# Handy I think anyway :P
		if (!$popup_window['on'] ||
			(
				$popup_window['on'] &&
				!$popup_window['menu'] &&
				!$popup_window['tool'] &&
				!$popup_window['width'] &&
				!$popup_window['height'] &&
				!$popup_window['resize'] &&
				!$popup_window['status'] &&
				!$popup_window['scroll'] &&
				!$popup_window['location']
			)
		) {
			$this->popup_window['on'] = $popup_window['on'];
			$update_query = "UPDATE $this->table_name SET popup_window='".$popup_window['on']."' WHERE pageid='$this->id'";
		} else {
			if (!$popup_window['height'] || !$popup_window['width']) return array(MYSOURCE_ERROR_CODE_ERROR, 'New Window Settings not updated - Please specify a width and height');
			$update_query = "UPDATE $this->table_name SET popup_window='".$popup_window['on']."', popup_window_menu='".$popup_window['menu']."', popup_window_tool='".$popup_window['tool']."', popup_window_width='".$popup_window['width']."', popup_window_height='".$popup_window['height']."', popup_window_resize='".$popup_window['resize']."', popup_window_status='".$popup_window['status']."', popup_window_scroll='".$popup_window['scroll']."', popup_window_location='".$popup_window['location']."' WHERE pageid='$this->id'";
			$this->popup_window = $popup_window;
		}
		if ($db->update($update_query)) {
			$this->clear_cache();
            return array(MYSOURCE_ERROR_CODE_NONE, 'New Window Settings Updated.');
        } else {
			return array(MYSOURCE_ERROR_CODE_ERROR, 'New Window Settings not Updated');
		}
	}

	 ###########################################
	# Sets/Resets info in the temporary array 
	function set_temp_information() {

		$page_copy = new BodyCopy($this->page_copy, 'page_copy');
		$this->_page_copy_keywords = $page_copy->get_keywords();

	}

	 ##################################################################
	# Prints the backend for the user - usually completely overwritten
	function print_backend() {
		$backend = &$this->setup_backend();
		$page = &$this->get_page();
		$db = &$this->get_db();
		$bodycopy  = new BodyCopy($this->bodycopy, 'bodycopy');
		$page_copy = new BodyCopy($this->page_copy, 'page_copy');

		switch($_POST['action']) {
			case 'Commit':
				$backend->add_message($this->set_title(gpc_stripslashes($_POST['title'])));
				$backend->add_message($bodycopy->update('bodycopy'));
				$backend->add_message($this->set_bodycopy($bodycopy->pack()));
				$backend->add_message($page_copy->update('page_copy'));
				$backend->add_message($this->set_page_copy($page_copy->pack()));

				$backend->add_message($this->set_number_per_row($_POST['number_per_row']));
				$backend->add_message($this->set_number_per_page($_POST['number_per_page']));
				$backend->add_message($this->set_position($_POST['position']));
				$backend->add_message($this->set_horizontal_divider($_POST['horizontal_divider']));
				$backend->add_message($this->set_vertical_divider($_POST['vertical_divider']));
				$backend->add_message($this->set_link_colour($_POST['link_colour']));
				$backend->add_message($this->set_use_anchors($_POST['use_anchors']));
				$backend->add_message($this->set_popup_window($_POST['popup_window']));

				# just reset the temp info, just in case
				$this->set_temp_information();
				$this->updated();
				break;
			default:
				break;
		}

		$backend->print_header();
		$backend->open_section();
		
		$backend->open_field('Instructions','top');
		?>
			There are 2 bodycopy editors for this template, one for the normal page contents (<i>Body Copy</i>) and one
			to allow you design how the sub pages are to appear (<i>Page Copy</i>).
			<p>
			In the <i>Page Copy</i> editor design how an individual page is to appear in the 
			sub page listing, indicating the different bits of information you want to place in different
			positions by using the following labels (the %-signs are necessary) :
			<li>%name%
			<li>%short_name%
			<li>%thumbnail%
			<li>%description%
			<li>%content%
			<br>
			<br>
			<span class="smallprint">(name, short_name and thumbnail get linked to the sub page)</span>
			<br><br>
		<?


		$backend->open_field('Title');
		echo text_box('title', $this->title, 50, 128);

		$backend->open_field('Body&nbsp;Copy','top');
		?><p class='smallprint'>The Normal Content of the Page</p><?
		$this->print_bodycopy_backend($bodycopy, 'bodycopy');

		$backend->open_field('Page&nbsp;Copy','top');
		?><p class='smallprint'>The definition used to display an individual sub page in the listing</p><?
		$this->print_bodycopy_backend($page_copy, 'page_copy');

		$backend->open_field('Sub Page Dividers', 'top');
		?> 
		<input type="checkbox" name="horizontal_divider" value="1" <?=($this->horizontal_divider == '1') ? 'CHECKED' : '';?>> Horizontal
		<br>
		<input type="checkbox" name="vertical_divider" value="1" <?=($this->vertical_divider == '1') ? ' CHECKED' : '';?>> Vertical
		<?

		$backend->open_field('Page Display');
		echo text_box('number_per_row',$this->number_per_row, 3, '', 'class=data');
		echo '<span class="smallprint"> sub-page(s) per row</span><br>';
		echo text_box('number_per_page',$this->number_per_page, 3, '', 'class=data');
		echo '<span class="smallprint"> sub-page(s) per page (leave empty or set to zero for no limit)</span>';

		$backend->open_field('SubPage Listing Position');
		echo combo_box('position', array('a' => 'Above Bodycopy', 'b' => 'Below Bodycopy', 'k' => 'Keyword Replace in Bodycopy'), $this->position);
		echo '<span class="smallprint"> If you choose Keyword replacement the Keyword to use is %subpage_list% and it should be used in the main Bodycopy</span>';

		$backend->open_field('Link Colour');
		echo colour_box('link_colour', $this->link_colour, true);

		$backend->open_field('Have Anchors', 'top');
		echo combo_box('use_anchors', Array('0' => 'No', '1' => 'Yes'), $this->use_anchors);
		echo '<div class="smallprint">Place anchors before each page that is printed, the anchor is the first virtual path for the page</div>';

		$backend->open_field('Open Links in New Window','top');
		echo combo_box('popup_window[on]', Array('0' => 'No', '1' => 'Yes'), $this->popup_window['on']);

		if ($this->popup_window['on']) {
			$backend->open_field('New Window Width','top');
			echo text_box('popup_window[width]',$this->popup_window['width'], 4, '', 'class=data');

			$backend->open_field('New Window Height','top');
			echo text_box('popup_window[height]',$this->popup_window['height'], 4, '', 'class=data');

			$backend->open_field('Show Toolbar?','top');
			echo combo_box('popup_window[tool]', Array('0' => 'No', '1' => 'Yes'), $this->popup_window['tool']);

			$backend->open_field('Show Menu Bar?','top');
			echo combo_box('popup_window[menu]', Array('0' => 'No', '1' => 'Yes'), $this->popup_window['menu']);

			$backend->open_field('Show Status Bar?','top');
			echo combo_box('popup_window[status]', Array('0' => 'No', '1' => 'Yes'), $this->popup_window['status']);

			$backend->open_field('Show Scrollbars?','top');
			echo combo_box('popup_window[scroll]', Array('0' => 'No', '1' => 'Yes'), $this->popup_window['scroll']);

			$backend->open_field('Show Location Bar?','top');
			echo combo_box('popup_window[location]', Array('0' => 'No', '1' => 'Yes'), $this->popup_window['location']);

			$backend->open_field('Allow Resizing of Window?','top');
			echo combo_box('popup_window[resize]', Array('0' => 'No', '1' => 'Yes'), $this->popup_window['resize']);
		}

		$backend->print_commit_button('Commit','document.edit.action.value=\'Commit\';document.edit.submit();');

		$backend->print_footer();
	}

	 ###########################################################
	# Returns the title as it should be printed on the frontend
	function get_title() {
		return $this->title;
	}

	  ##########################################################################
	 # Define print_body() - this *should* get called by the site's design xtra
	function print_body() {
		$page = &$this->get_page();
		$db = &$this->get_db();
		$site = &$this->get_site();

		$bodycopy  = new BodyCopy($this->bodycopy, 'bodycopy');
		$page_copy = new BodyCopy($this->page_copy, 'page_copy');

		# if the subpage list is below the body copy, print the bodycopy first.
		if ($this->position == 'b') {
			$bodycopy->paint();
			if ($this->horizontal_divider) {
				echo "<center><hr size=\"1\" noshade\"></center>";
			}
		}

		# get the sub pages, do the array values to make sure we have a proper indexed array
		# NOTE: we don't need to do any read access checks on these pages, because the site
		#       object stips out any pages that we don't have
		$sub_pageids = array_values($page->get_subpageids());

		$cell_width = floor(100 / $this->number_per_row);

		# are we printing more than one page?
		global $start_printing_at;
		if (!$start_printing_at) $start_printing_at = 0;
		if (!$this->number_per_page) {
			$stop_printing_at = count($sub_pageids);
		} else {
			$stop_printing_at = $start_printing_at + $this->number_per_page;
			if ($stop_printing_at > count($sub_pageids)) $stop_printing_at = count($sub_pageids);
		}

		$pages_printed = 0;

		#start the cacheing if your using keyword replacements
		if ($this->position == 'k')
			ob_start();
		?><table border="0" cellspacing="0" cellpadding="0" width="100%"><tr><?
		for($i = $start_printing_at; $i < $stop_printing_at; $i++) {
			$subpage = &$this->get_page($sub_pageids[$i]);
			if (!$subpage->id) continue;

			$url = $subpage->get_href();

			echo '<td width="'.$cell_width.'%" valign="top">';

			# if we want to print anchors and the page has a dir
			if ($this->use_anchors && $subpage->dirs[0]) {
				echo '<a name="'.$subpage->dirs[0].'"></a>';
			}

			$link_colour = ($this->link_colour) ? ' style="color: #'.$this->link_colour.'"' : '';

			$subpage_href = ($this->popup_window['on']) ? '#" onclick="javascript:window.open(\''.$url.'\', \'subpage\', \'toolbar='.$this->popup_window['tool'].',width='.$this->popup_window['width'].',height='.$this->popup_window['height'].',scrollbars='.$this->popup_window['scroll'].',resizable='.$this->popup_window['resize'].',menubar='.$this->popup_window['menu'].',status='.$this->popup_window['status'].',location='.$this->popup_window['location'].'\'); return false"' : $url ;

			if (is_array($this->_page_copy_keywords)) {
				$keyword_replacements = Array();
				foreach ($this->_page_copy_keywords as $keyword) {
					switch($keyword) {
						case 'name' :
							$keyword_replacements['name'] = '<a href="'.$subpage_href.'"'.$link_colour.'>'.$subpage->name.'</a>';
						break;

						case 'short_name' :
							$keyword_replacements['short_name'] = '<a href="'.$subpage_href.'"'.$link_colour.'>'.$subpage->short_name.'</a>';
						break;

						case 'thumbnail' :
							$temp = $subpage->image_tag("thumbs/page_thumb", $subpage->name , 0, 0, 'border="0"');
							echo "<br>";
							#Try to see if you can extract both an image tag and caption so you can print seperately
							if (ereg("<img src=\"[^\\\"]+\"[^\>]*\>", $temp, $imgtag) && preg_match("/\<td class=fineprint\>(.*)\<\/td\>/i",$temp,$captiontag))
								$keyword_replacements['thumbnail'] = '<table><tr><td><a href="'.$subpage_href.'">'.$imgtag[0].'</a></td></tr><tr>'.$captiontag[0].'</tr></table>';
							else #otherwise just do it like it used to be done
								$keyword_replacements['thumbnail'] = '<a href="'.$subpage_href.'">'.$subpage->image_tag("thumbs/page_thumb", $subpage->name , 0, 0, 'border="0"').'</a>';
						break;

						case 'description' :
							$keyword_replacements['description'] = $subpage->description;
						break;

						case 'content' :
							$template = &$subpage->get_template();
							$keyword_replacements['content'] = $template->get_html();
						break;
					}
				}
				$page_copy->add_replace_keywords($keyword_replacements);
			}
			$page_copy->paint();

			echo '</td>';
			$pages_printed++;

			if ($pages_printed == $this->number_per_row) {
				$pages_printed = 0;
				echo '</tr>';

				if ($this->horizontal_divider && ($i < count($sub_pageids) - 1)) {
					$colspan = $this->number_per_row;
					# if we are using a vertical divider, 
					# add one less than the number of rows because we don't put a divider after the last cell
					if ($this->vertical_divider) $colspan += $this->number_per_row - 1;
					echo '<tr><td colspan="'.$colspan.'" align="center">'.'<hr size="1" noshade></td></tr>';
				}

				echo '<tr>';

			} else {
				echo ($this->vertical_divider) ? '<td>&nbsp;|&nbsp;</td>' : '';
			}

		} # end foreach

		echo '</tr></table>';

		if ($this->number_per_page) {
			?>
			<br><br>
			<table border="0" width="100%" align="center">
				<tr>
					<td align="right" width="50%">
					<?
					if ($start_printing_at >= $this->number_per_page) {	
						?><a href="<?=$page->get_href(true)?>start_printing_at=<?=($start_printing_at - $this->number_per_page)?>"><< Previous</a><?
					} 
					?>&nbsp;</td><td align="left" width="50%">&nbsp;<?
					if (($start_printing_at + $this->number_per_page) < count($sub_pageids)) {	
						?><a href="<?=$page->get_href(true)?>start_printing_at=<?=($start_printing_at + $this->number_per_page)?>">Next >></a><?
					}
					?>
					</td>
				</tr>
			</table>
			<?
		}

		#use the cache as what to fill the keyword replacement in the bodycopy
		if ($this->position == 'k') {
			$buffer = ob_get_contents();
			ob_end_clean();
			$replace['subpage_list'] = $buffer;
			$bodycopy->add_replace_keywords($replace);
			$bodycopy->paint();
		}

		# if the page listing is above the body copy...
		if ($this->position == 'a') {
			$bodycopy->paint();
		}

	}# end print_body()

}#end class

?>
