#import "MACatalogs.h"
#import <MTextImageCell.h>
#import <MSchemaDataSource.h>
#import <NSString_extras.h>
#import <MTreeDataSource.h>
#import <MMySQLDispatcher.h>
#import "MATableMaintenanceController.h"

@interface MACatalogIndexItem : MTreeItem
{
  @public
  MYX_TABLE_INDEX *index;
  MYX_TABLE_INDEX_COLUMN *column;
}
- (id)initRoot:(MYX_SCHEMA_TABLE_STATUS*)item;
@end

@implementation MACatalogIndexItem
- (id)initRoot:(MYX_SCHEMA_TABLE_STATUS*)item
{
  self= [super initWithTag:'C' repr:nil];
  if (self)
  {
    unsigned int i, j, k;
    for (i= 0; i < item->schema_tables_num; i++)
    {
      MYX_TABLE_STATUS *table= item->schema_tables+i;
      MACatalogIndexItem *tit=nil, *cit;
      for (j= 0; j < table->indexes_num; j++)
      {
        MYX_TABLE_INDEX *idx= table->indexes+j;
        if (strcmp((char*)idx->table_name, (char*)table->table_name)==0)
        {
          tit= [[MACatalogIndexItem alloc] initWithTag:'I' repr:[NSString stringWithUTF8String:table->table_name]];
          tit->index= idx;
          [self addChild:tit];
          [tit release];
          
          for (k= 0; k < idx->index_columns_num; k++)
          {
            cit= [[MACatalogIndexItem alloc] initWithTag:'C' repr:[NSString stringWithUTF8String:idx->key_name]];
            cit->column= idx->index_columns+k;
            [tit addChild:cit];
            [cit release];
          }
        }
      }
    }
  }
  return self;
}

- (id)valueForIdentifier:(NSString*)ident
{
  if ([self tag] == 'I')
  {
    if ([ident isEqualToString:@"column"])
    {
      return [NSString stringWithUTF8String:index->table_name];
    }
    else if ([ident isEqualToString:@"name"])
    {
      return [NSString stringWithUTF8String:index->key_name];
    }
    else if ([ident isEqualToString:@"type"])
    {
      return [NSString stringWithUTF8String:index->index_type];
    }
    else if ([ident isEqualToString:@"unique"])
    {
      return index->unique?@"UNIQUE":@"-";
    }
    else if ([ident isEqualToString:@"null"])
    {
      return index->not_null?@"NOT NULL":@"NULL";
    }
  }
  else
  {
    if ([ident isEqualToString:@"column"])
    {
      return [NSString stringWithUTF8String:column->column_name];
    }
    else if ([ident isEqualToString:@"seq"])
    {
      return [NSString stringWithUTF8String:column->seq_in_index];
    }
    else if ([ident isEqualToString:@"collation"])
    {
      return *column->collation=='A'?@"Ascending":@"";
    }
  }
  return @"";
}

@end


@interface MACatalogs(Private)
- (void)tableStatusArrived:(id)arg result:(void*)res;
@end


@implementation MACatalogs(Private)

- (void)tableStatusArrived:(id)arg result:(void*)res
{
  long long index_length, data_length, row_count;
  unsigned int i;
  
  if (_tableStatus)
    myx_free_schema_table_status(_tableStatus);
  _tableStatus= (MYX_SCHEMA_TABLE_STATUS*)res;
  [tablesTable reloadData];
  
  if (_tableStatus)
    [[indexOutline dataSource] setRoot:[[[MACatalogIndexItem alloc] initRoot:_tableStatus] autorelease]];
  else
    [[indexOutline dataSource] setRoot:nil];
  [indexOutline reloadData];
  
  // calculate summaries
  index_length= 0;
  data_length= 0;
  row_count= 0;
  if (_tableStatus)
  {
    for (i= 0; i < _tableStatus->schema_tables_num; i++)
    {
      index_length+= strtoll((char*)_tableStatus->schema_tables[i].data_length?:"0", NULL, 0);
      data_length+= strtoll((char*)_tableStatus->schema_tables[i].index_length?:"0", NULL, 0);
      row_count+= strtoll((char*)_tableStatus->schema_tables[i].rows?:"0", NULL, 0);
    }
  }
  [[tableStatsMatrix cellWithTag:111] setStringValue:[NSString stringWithFormat:@"No. of Tables: %i", _tableStatus?_tableStatus->schema_tables_num:0]];
  [[tableStatsMatrix cellWithTag:112] setStringValue:[NSString stringWithFormat:@"No. of Rows: %lli", row_count]];
  [[tableStatsMatrix cellWithTag:113] setStringValue:[NSString stringWithFormat:@"Data Length: %@B", [NSString stringWithMultNumber:data_length]]];
  [[tableStatsMatrix cellWithTag:114] setStringValue:[NSString stringWithFormat:@"Index Length: %@B", [NSString stringWithMultNumber:index_length]]];
}

@end


@implementation MACatalogs

- (IBAction)toggleTableDetails:(id)sender
{
  NSRect rect= (sender != nil ? [[topBox window] frame] : [topBox frame]);
  float bheight= [tableDetailsTab frame].size.height;

  // change autoresizing, so that the layout stays the way we want as we resize the window
  [tableStatsMatrix setAutoresizingMask:NSViewWidthSizable|NSViewMinYMargin];
  [tableDetailToggleButton setAutoresizingMask:NSViewWidthSizable|NSViewMinYMargin];
  [[topBox viewWithTag:14] setAutoresizingMask:NSViewWidthSizable|NSViewMinYMargin];
  [tableScrollView setAutoresizingMask:NSViewWidthSizable|NSViewMinYMargin];
  [[tableDetailsTab superview] setAutoresizingMask:NSViewWidthSizable|NSViewHeightSizable];
  
  if ([tableDetailToggleButton state] == NSOnState)
  {
    rect.size.height+= bheight;

    if (sender == nil)
      [topBox setFrame:rect];
    else
    {
      rect.origin.y-= bheight;
      [[topBox window] setFrame:rect display:YES animate:YES];
    }
  }
  else
  {
    rect.size.height-= bheight;
    
    if (sender == nil)
      [topBox setFrame:rect];
    else
    {
      rect.origin.y+= bheight;
      [[topBox window] setFrame:rect display:YES animate:YES];
    }
  }

  [[tableDetailsTab superview] setAutoresizingMask:NSViewWidthSizable];
  [tableDetailToggleButton setAutoresizingMask:NSViewWidthSizable|NSViewMaxYMargin|NSViewMaxXMargin];
  [[topBox viewWithTag:14] setAutoresizingMask:NSViewWidthSizable|NSViewMaxYMargin|NSViewMaxXMargin];
  [tableScrollView setAutoresizingMask:NSViewWidthSizable|NSViewHeightSizable];
  [tableStatsMatrix setAutoresizingMask:NSViewWidthSizable|NSViewMaxYMargin];
}

- (IBAction)openTableMaintenance:(id)sender
{
  MATableMaintenanceController *mnt;
  NSMutableArray *tables= [[NSMutableArray alloc] init];
  NSIndexSet *rows= [tablesTable selectedRowIndexes];
  unsigned int i;
  int row= [schemataOutline selectedRow];
  MSchemaItem *item= row >= 0 ? [schemataOutline itemAtRow:row] : nil;
  if (!item || item->type != MSchemaItemType) 
    return;
  MYX_SCHEMA *schema= [item schema];

  for (i= [rows firstIndex]; i <= [rows lastIndex]; i= [rows indexGreaterThanIndex:i])
  {
    [tables addObject:[NSString stringWithFormat:@"%s.%s",schema->schema_name,_tableStatus->schema_tables[i].table_name]];
  }

  mnt= [[MATableMaintenanceController alloc] initWithWindowNibName:@"TableMaintenance"];
  [mnt runWithTables:tables dispatcher:[_owner dispatcher]];

  [mnt release];
  [tables release];
}

- (IBAction)createTable:(id)sender
{
}

- (IBAction)editTable:(id)sender
{
}

- (IBAction)refreshTables:(id)sender
{
  int row= [schemataOutline selectedRow];
  MSchemaItem *item= row >= 0 ? [schemataOutline itemAtRow:row] : nil;
  if (item && item->type == MSchemaItemType) 
  {
    [tablesCaption setStringValue:[NSString stringWithFormat:@"Tables in Schema '%@'",[item repr]]];
    [tablesCaption setStringValue:[NSString stringWithFormat:@"Indices in Schema '%@'",[item repr]]];
    
    [[_owner dispatcher] performCallback:(void*(*)(MYSQL*,void*,void*))myx_get_schema_table_status
                                argument:[item schema]->catalog_name
                                argument:[item schema]->schema_name
                        finishedSelector:@selector(tableStatusArrived:result:)
                                argument:nil
                                  target:self];
  }
  else
  {
    [tablesCaption setStringValue:[NSString stringWithFormat:@""]];
    [tablesCaption setStringValue:[NSString stringWithFormat:@""]];
    [self tableStatusArrived:nil result:NULL];
  }
}


+ (NSImage*)icon
{
  return [[[NSImage alloc] initWithContentsOfFile: 
    [[NSBundle mainBundle] pathForResource:@"catalogs"
                                    ofType:@"png"]] autorelease];
}

+ (NSString*)label
{
  return @"Catalogs";
}

+ (NSString*)toolTip
{
  return @"Catalogs in the connected MySQL server.";
}

- (id)initWithOwner: (id<MAdministratorProtocol>)owner
{
  self= [super initWithNibFile: @"Catalogs" panelOwner: owner];
  if (self)
  {
    [self toggleTableDetails:nil];
    _defaultFrame= [[self topView] frame];
    
    _tableIcon= [[self loadImage:@"16x16_Table"] retain];
    
    {
      MTextImageCell *cell= [[[MTextImageCell alloc] init] autorelease];
      [cell setEditable: YES];
      [cell setFont:[[[schemataOutline tableColumnWithIdentifier:@"type"] dataCell] font]];
      [[schemataOutline tableColumnWithIdentifier:@"column"] setDataCell: cell];

      cell= [[[MTextImageCell alloc] init] autorelease];
      [cell setEditable: YES];
      [cell setFont:[[[tablesTable tableColumnWithIdentifier:@"type"] dataCell] font]];
      [[tablesTable tableColumnWithIdentifier:@"name"] setDataCell: cell];
    }
    
    [indexOutline setDataSource:[[MTreeDataSource alloc] init]];
  }
  return self;
}

- (void)dealloc
{
  [_tableIcon release];
  if (_tableStatus)
    myx_free_schema_table_status(_tableStatus);
  [tableDetailsTab release];
  [super dealloc];
}

- (void)awakeFromNib
{
  [tableDetailsTab retain];
}

- (NSView*)sideView
{
  return sideBox;
}

- (void)didShow
{
  if (![schemataOutline dataSource])
    [schemataOutline setDataSource:[_owner sharedSchemaDS]];
}

//============================= Delegate ================================

- (void)tableViewSelectionDidChange:(NSNotification *)aNotification
{
  if ([aNotification object] == tablesTable)
  {
    int row= [tablesTable selectedRow];
    MYX_TABLE_STATUS *ts;
    MYX_TABLE_STATUS zero;
    
    if (row < 0)
    {
      memset(&zero, 0, sizeof(zero));
      ts= &zero;
    }
    else
      ts= _tableStatus->schema_tables+row;
    
    [tableStatusText setStringValue:[NSString stringWithFormat:@"%s\n%s\n%s\n%s\n%s",
                                        (char*)ts->table_type?:"",
                                        (char*)ts->row_format?:"",
                                    (char*)ts->auto_increment?:"",
                                    (char*)ts->create_options?:"",
                                           (char*)ts->comment?:""]];
    
    [tableStatsDataText setStringValue:[NSString stringWithFormat:@"%s\n%s\n%s\n%s\n%s\n%s",
                                                 (char*)ts->rows?:"",
                                       (char*)ts->avg_row_length?:"",
                                          (char*)ts->data_length?:"",
                                      (char*)ts->max_data_length?:"",
                                         (char*)ts->index_length?:"",
                                            (char*)ts->data_free?:""]];
    
    [tableStatsTimeText setStringValue:[NSString stringWithFormat:@"%s\n%s\n%s",
                                          (char*)ts->create_time?:"",
                                          (char*)ts->update_time?:"",
                                           (char*)ts->check_time?:""]];
  }
}


- (void)tableView:(NSTableView *)aTableView
  willDisplayCell:(id)aCell
   forTableColumn:(NSTableColumn *)aTableColumn
              row:(int)rowIndex
{
  if (aTableView == tablesTable && [[aTableColumn identifier] isEqualToString:@"name"])
  {
    [aCell setImage:_tableIcon];
  }
}

- (void)outlineView:(NSOutlineView *)outlineView 
    willDisplayCell:(id)cell 
     forTableColumn:(NSTableColumn *)tableColumn 
               item:(id)item
{
  if (outlineView == schemataOutline)
  {
    [cell setImage:[item icon]];
  }
}

- (void)outlineViewSelectionDidChange:(NSNotification *)notification
{
  NSOutlineView *oview= [notification object];

  if (oview == schemataOutline)
  {  
    [self refreshTables:nil];
  }
}


//============================= DataSource ================================

- (int)numberOfRowsInTableView:(NSTableView *)aTableView
{
  if (aTableView == tablesTable)
    return _tableStatus ? _tableStatus->schema_tables_num : 0;
  else
    return 0;
}

- (id)tableView:(NSTableView *)aTableView 
objectValueForTableColumn:(NSTableColumn *)aTableColumn 
            row:(int)rowIndex
{
  if (aTableView == tablesTable)
  {
    NSString *ident= [aTableColumn identifier];
    MYX_TABLE_STATUS *table= _tableStatus->schema_tables+rowIndex;
    
    if ([ident isEqualToString:@"name"])
    {
      return [NSString stringWithUTF8String:table->table_name];
    }
    else if ([ident isEqualToString:@"type"])
    {
      return [NSString stringWithUTF8String:(char*)table->table_type?:""];
    }
    else if ([ident isEqualToString:@"format"])
    {
      return [NSString stringWithUTF8String:(char*)table->row_format?:""];
    }
    else if ([ident isEqualToString:@"rows"])
    {
      return [NSString stringWithUTF8String:(char*)table->rows?:""];
    }
    else if ([ident isEqualToString:@"data"])
    {
      return [NSString stringWithMultNumber:strtoll((char*)table->data_length?:"0",NULL,0)];
    }
    else if ([ident isEqualToString:@"index"])
    {
      return [NSString stringWithMultNumber:strtoll((char*)table->index_length?:"0",NULL,0)];
    }
    else if ([ident isEqualToString:@"update"])
    {
      return [NSString stringWithUTF8String:(char*)table->update_time?:""];
    }
  }
  return 0;
}

@end
