//
//  MAPanel.m
//  MySQL Administrator
//
//  Created by Alfredo Kojima on Thu Jun 24 2004.
//  Copyright (c) 2004 MySQL AB. All rights reserved.
//

#import "MAPanel.h"


@implementation MAPanel

+ (NSImage*)icon
{
  return nil;
}

+ (NSString*)label
{
  return nil;
}

+ (NSString*)toolTip
{
  return nil;
}

- (id)initWithNibFile: (NSString*)file
           panelOwner: (id<MAdministratorProtocol>)owner
{
  self= [super init];
  if (!self)
    return nil;
  
  _owner= owner;
  
  if (![NSBundle loadNibNamed:file owner:self])
  {
    NSLog(@"Could not load nib file %@", file);
    [self release];
    return nil;
  }
  
  return self;
}

- (id)initWithOwner:(id<MAdministratorProtocol>)owner
{
  // must be overriden
  return nil;
}

- (NSView*)topView
{
  return topBox;
}

- (NSView*)sideView
{
  return nil;
}

- (BOOL)willShow
{
  return YES;
}

- (void)didShow
{
}

- (BOOL)willHide
{
  return YES;
}

- (void)didHide
{
}

- (BOOL)willClose
{
  return YES;
}


- (NSImage*)loadImage: (NSString*)file
{
  NSImage *image= [[[NSImage alloc] initWithContentsOfFile: 
    [[NSBundle mainBundle] pathForResource:file
                                    ofType:@"png"]] autorelease];
  if (!image)
    NSLog(@"Could not load image %@", file);
  return image;
}

- (NSRect)defaultFrame
{
  return _defaultFrame;
}

- (void)setNeedsSave:(BOOL)flag
{
  _needsSave= flag;
  [[topBox window] setDocumentEdited:flag];
}

- (BOOL)needsSave
{
  return _needsSave;
}

- (void)showMessageSheet:(NSString*)message
                    info:(NSString*)info
{
  NSAlert *alert = [[[NSAlert alloc] init] autorelease];
  
  [alert addButtonWithTitle:@"OK"];
  [alert setMessageText:message];
  if (info)
    [alert setInformativeText:info];
  
  [alert setAlertStyle:NSWarningAlertStyle];
  
  [alert beginSheetModalForWindow:[topBox window] modalDelegate:self 
                   didEndSelector:nil contextInfo:nil];
}
@end
