#import "MAServerConnections.h"
#import "MMySQLDispatcher.h"

@interface UserDataSource: NSObject
{
  NSDictionary *_users;
}

- (void)setUsers:(NSDictionary*)users;

- (int)numberOfRowsInTableView:(NSTableView *)aTableView;
- (id)tableView:(NSTableView *)aTableView objectValueForTableColumn:(NSTableColumn *)aTableColumn 
            row:(int)rowIndex;

@end

@implementation UserDataSource

- (void)dealloc
{
  [_users release];
  [super dealloc];
}

- (void)setUsers:(NSDictionary*)users
{
  if (_users != users)
  {
    if (_users) [_users release];
    _users= [users retain];
  }
}


- (int)numberOfRowsInTableView:(NSTableView *)aTableView
{  
  if (!_users)
    return 0;
  
  return [_users count];
}


- (id)tableView:(NSTableView *)aTableView objectValueForTableColumn:(NSTableColumn *)aTableColumn 
            row:(int)rowIndex
{
  NSString *user;
  NSEnumerator *en;

  en= [_users keyEnumerator];
  while ((user= [en nextObject]))
  {
    if (rowIndex-- == 0)
    {
      if ([[aTableColumn identifier] isEqualToString:@"user"])
        return user;
      else if ([[aTableColumn identifier] isEqualToString:@"threads"])
        return [[_users objectForKey:user] stringValue];
      else
        return nil;
    }
  }
  return nil;
}

@end



@interface ProcessDataSource : NSObject
{
  MYX_PROCESS_LIST *_plist;
  NSMutableArray *_users;
}

- (void)setProcessList:(MYX_PROCESS_LIST*)plist;
- (void)setUserFilter:(NSMutableArray*)users;
- (NSMutableArray*)userFilter;

- (int)numberOfRowsInTableView:(NSTableView *)aTableView;
- (id)tableView:(NSTableView *)aTableView objectValueForTableColumn:(NSTableColumn *)aTableColumn 
            row:(int)rowIndex;
@end


@implementation ProcessDataSource

- (void)dealloc
{
  [_users release];
  [super dealloc];
}

- (void)setProcessList:(MYX_PROCESS_LIST*)plist
{
  _plist= plist;
}

- (void)setUserFilter:(NSMutableArray*)users
{
  if (_users != users)
  {
    if (_users) [_users release];
    _users= [users retain];
  }
}

- (NSMutableArray*)userFilter
{
  return _users;
}

- (int)numberOfRowsInTableView:(NSTableView *)aTableView
{
  if (!_plist)
    return 0;
  
  if (!_users)
    return _plist->process_infos_num;
  else
  {
    unsigned int i;
    int count= 0;
    for (i= 0; i < _plist->process_infos_num; i++)
    {
      if ([_users indexOfObject:[NSString stringWithUTF8String:_plist->process_infos[i].user]]!=NSNotFound)
        count++;
    }
    return count;
  }
}

- (id)tableView:(NSTableView *)aTableView objectValueForTableColumn:(NSTableColumn *)aTableColumn 
            row:(int)rowIndex
{
  MYX_PROCESS_INFO *info= NULL;
  if (!_users || [_users count] == 0)
    info= _plist->process_infos+rowIndex;
  else
  {
    unsigned int i;
    int count= 0;
    for (i= 0; i < _plist->process_infos_num; i++)
    {
      if ([_users indexOfObject:[NSString stringWithUTF8String:_plist->process_infos[i].user]]!=NSNotFound)
      {
        if (count++ == rowIndex)
        {
          info= _plist->process_infos+i;
          break;
        }
      }
    }
  }  
  
  if (info)
  {
    id ident= [aTableColumn identifier];
    if (!aTableColumn || [ident isEqualToString:@"id"])
    {
      return [NSString stringWithUTF8String:info->id];
    }
    else if ([ident isEqualToString:@"user"])
    {
      return [NSString stringWithUTF8String:info->user];
    }
    else if ([ident isEqualToString:@"host"])
    {
      return [NSString stringWithUTF8String:info->host];
    }
    else if ([ident isEqualToString:@"db"])
    {
      return [NSString stringWithUTF8String:info->db];
    }
    else if ([ident isEqualToString:@"command"])
    {
      return [NSString stringWithUTF8String:info->command];
    }
    else if ([ident isEqualToString:@"time"])
    {
      return [NSString stringWithUTF8String:info->time];
    }
    else if ([ident isEqualToString:@"state"])
    {
      return [NSString stringWithUTF8String:info->state];
    }
  }
  return nil;
}

@end


@interface MAServerConnections(Private)
- (void)updateProcessList:(id)arg list:(MYX_PROCESS_LIST*)plist;
@end

@implementation MAServerConnections(Private)
- (void)updateProcessList:(id)arg list:(MYX_PROCESS_LIST*)plist
{
  if (_plist)
    myx_free_process_list(_plist);
  _plist= plist;
  
  if (_plist)
  {
    unsigned int i;
    [_users removeAllObjects];
    for (i= 0; i < _plist->process_infos_num; i++)
    {
      NSString *s= [NSString stringWithUTF8String:_plist->process_infos[i].user];
      NSNumber *n;
      if ((n=[_users objectForKey:s]))
        [_users setObject:[NSNumber numberWithInt:0] forKey:s];
      else
        [_users setObject:[NSNumber numberWithInt:1+[n intValue]] forKey:s];
    }
  }
  
  [_connectionsDS setProcessList:_plist];
  [_connectionsDS setUserFilter:[[[NSMutableArray alloc] init] autorelease]];
  [_fullDS setProcessList:_plist];
  [_userDS setUsers:_users];
  [connectionsTable reloadData];
  [fullTable reloadData];
  [userTable reloadData];
}

- (void)tabView:(NSTabView *)atabView didSelectTabViewItem:(NSTabViewItem *)tabViewItem
{
  if ([tabView indexOfTabViewItem:tabViewItem] == 0)
    [killUserButton setEnabled:NO];
  else
    [killUserButton setEnabled:YES];
}

@end

@implementation MAServerConnections

- (IBAction)killConnection:(id)sender
{
  NSIndexSet *rows;
  unsigned int row;
  id table;
  id ds;
  
  if ([tabView indexOfTabViewItem:[tabView selectedTabViewItem]]==0)
    table= fullTable;
  else
    table= connectionsTable;
  
  rows= [table selectedRowIndexes];
  ds= [table dataSource];

  for (row= [rows firstIndex]; row <= [rows lastIndex]; row= [rows indexGreaterThanIndex:row])
  {
    id pid= [ds tableView:table objectValueForTableColumn:nil row:row];
    [[_owner dispatcher] performCallback:(void*(*)(MYSQL*,void*))myx_kill_thread
                                argument:(void*)[pid intValue]
                        finishedSelector:nil
                                argument:nil
                                  target:nil];
  }
  [self refresh:self];
}

- (IBAction)killUser:(id)sender
{
  int row;
  id table;
  id ds;
  int count;
  
  if ([tabView indexOfTabViewItem:[tabView selectedTabViewItem]]==0)
    return;
  
  ds= [connectionsTable dataSource];
  
  count= [ds numberOfRowsInTableView:connectionsTable];
  for (row= 0; row < count; row++)
  {
    id pid= [ds tableView:table objectValueForTableColumn:nil row:row];
    [[_owner dispatcher] performCallback:(void*(*)(MYSQL*,void*))myx_kill_thread
                                argument:(void*)[pid intValue]
                        finishedSelector:nil
                                argument:nil
                                  target:nil];
  }
  [self refresh:self];
}

- (IBAction)refresh:(id)sender
{
  [[_owner dispatcher] performCallback:(void*(*)(MYSQL*))myx_get_process_list
                      finishedSelector:@selector(updateProcessList:list:)
                              argument:nil
                                target:self];
}


+ (NSImage*)icon
{
  return [[[NSImage alloc] initWithContentsOfFile: 
    [[NSBundle mainBundle] pathForResource:@"server_connections"
                                    ofType:@"png"]] autorelease];
}

+ (NSString*)label
{
  return @"Connections";
}

+ (NSString*)toolTip
{
  return @"Current connections to the MySQL server.";
}


- (void)awakeFromNib
{
  _connectionsDS= [[ProcessDataSource alloc] init];
  _fullDS= [[ProcessDataSource alloc] init];
  _userDS= [[UserDataSource alloc] init];
  [fullTable setDataSource:_fullDS];
  [connectionsTable setDataSource:_connectionsDS];
  [userTable setDataSource:_userDS];
}


- (id)initWithOwner: (id<MAdministratorProtocol>)owner
{
  self= [super initWithNibFile: @"ServerConnections" panelOwner: owner];
  
  if (self)
  {
    _defaultFrame= [[self topView] frame];
  
    _users= [[NSMutableDictionary alloc] init];
  }
  return self;
}

- (void)dealloc
{
  [_connectionsDS release];
  [_fullDS release];
  [_userDS release];
  [_users release];
  if (_plist)
    myx_free_process_list(_plist);
  [super dealloc];
}

- (void)didShow
{
  [self refresh:self];
}

//==================== Delegates =======================

- (void)tableViewSelectionDidChange:(NSNotification *)aNotification
{
  if ([aNotification object] == userTable)
  {
    NSIndexSet *iset= [userTable selectedRowIndexes];
    NSMutableArray *array= [_connectionsDS userFilter];
    NSEnumerator *en;
    NSString *user;
    int i;
        
    [array removeAllObjects];
    en= [_users keyEnumerator];
    i= 0;
    while ((user= [en nextObject]))
    {
      if ([iset containsIndex:i])
        [array addObject: user];
      i++;
    }

    [connectionsTable reloadData];
  }
}

@end
