#import "MAServerLogs.h"
#import "MAServerLogView.h"

@implementation MAServerLogs

+ (NSImage*)icon
{
  return [[[NSImage alloc] initWithContentsOfFile: 
    [[NSBundle mainBundle] pathForResource:@"server_logs"
                                    ofType:@"png"]] autorelease];
}

+ (NSString*)label
{
  return @"Logs";
}

+ (NSString*)toolTip
{
  return @"View MySQL Server Logs.";
}


- (id)initWithOwner: (id<MAdministratorProtocol>)owner
{
  self= [super initWithNibFile: @"ServerLogs" panelOwner: owner];
  if (self)
  {
    _defaultFrame= [[self topView] frame];
  
    [tabView removeTabViewItem:[tabView tabViewItemAtIndex:0]];  
  }
  return self;
}

- (void)dealloc
{
  [_pages release];
  
  [super dealloc];
}

- (void)didShow
{
  if (!_pages)
  {
    _pages= [[NSMutableArray alloc] init];
    [self createPage: [NSString stringWithFormat:@"/usr/local/mysql/data/%@.err", [[NSHost currentHost] name]]
            withName: @"Error Log"
       parseFunction: myx_parse_error_log];
  }
}

- (void)createPage:(NSString*)path
          withName:(NSString*)name
     parseFunction:(MALogParserFunction)func
{
  MAServerLogView *view= [[[MAServerLogView alloc] initWithPath:path 
                                                  parseFunction:func] autorelease];
  
  if (![NSBundle loadNibNamed:@"ServerLogView" owner:view])
  {
    NSRunAlertPanel(nil,@"Could not instantiate interface for log viewing.",
                    nil, nil, nil);
  }
  else
  {
    NSTabViewItem *item= [[[NSTabViewItem alloc] initWithIdentifier:name] autorelease];
    [item setLabel:name];
    [_pages addObject:view];
    [item setView:[view topView]];
    [tabView addTabViewItem:item];
  }
}

@end
