#import "MAServiceControl.h"

#include <Security/Authorization.h>

#import "MAdministrator.h"

@interface MAServiceControl(Private)
- (void)updateStatus;
- (void)startStopServer:(BOOL)flag;
- (char*)getStartupItem;
@end

@implementation MAServiceControl(Private)
- (void)updateStatus
{
  NSImage *image;
  NSString *status;
  NSString *blabel;
  
  switch ([_owner serverStatus])
  {
    case 0:
      image= [self loadImage: @"service_status_stopped"];
      status= @"Server is Stopped";
      blabel= @"Start Server";
      break;
    case 1:
      image= [self loadImage: @"service_status_running"];
      status= @"Server is Running";
      blabel= @"Stop Server";
      break;
    default:
      image= [self loadImage: @"service_status_unknown"];
      status= @"Cannot determine server status";
      blabel= nil;
    break;
  }
  
  [statusImage setImage: image];
  [statusLabel setStringValue: status];
  if (blabel)
  {
    [toggleButton setEnabled:YES];
    [toggleButton setTitle:blabel];
  }
  else
  {
    [toggleButton setEnabled:NO];
    [toggleButton setTitle:@"Start Server"];
  }  
}

- (char*)getStartupItem
{
  if ([[NSFileManager defaultManager] fileExistsAtPath:@"/Library/StartupItems/MySQLCOM"])
    return "/Library/StartupItems/MySQLCOM/MySQL";
  else if ([[NSFileManager defaultManager] fileExistsAtPath:@"/Library/StartupItems/MySQL"])
    return "/Library/StartupItems/MySQL/MySQL";
  else
    return NULL;
}

- (void)startStopServer:(BOOL)flag
{
  const char *args[]={
    NULL,
    flag?"start":"stop",
    NULL
  };
  const char *path= [self getStartupItem];
  AuthorizationRef authRef;
  int rc;
  
  if (!path)
    return;
  
  args[0]= path;
  
  if (AuthorizationCreate(NULL, kAuthorizationEmptyEnvironment,
                          kAuthorizationFlagDestroyRights|kAuthorizationFlagExtendRights|kAuthorizationFlagInteractionAllowed, 
                          &authRef)!=errAuthorizationSuccess)
  {
    NSLog(@"Could not create authorization reference object.");
    return;
  }
  if ((rc= AuthorizationExecuteWithPrivileges(authRef,
                                              "/usr/bin/sudo",
                                              kAuthorizationFlagDefaults,
                                              args,
                                              NULL)) != errAuthorizationSuccess)
  {
    NSLog(@"Could not obtain rights to start/stop MySQL server (%i).", rc);
    return;
  }
}

@end

@implementation MAServiceControl

- (IBAction)toggleServer:(id)sender
{
  [self startStopServer:NO];
}

- (void)awakeFromNib
{
  [self updateStatus];
  
  if ([self getStartupItem]==NULL)
  {
    [messageText setString:@"The MySQL Startup Item was not found in /Librart/StartupItems\n"
      "You must select the \"Install Startup Item\" option during installation to enable "
      "server control from this tool."];
    [toggleButton setEnabled:NO];
    [startOnBootCheck setEnabled:NO];
  }
}

+ (NSImage*)icon
{
  return [[[NSImage alloc] initWithContentsOfFile: 
    [[NSBundle mainBundle] pathForResource:@"service_config"
                                    ofType:@"png"]] autorelease];
}

+ (NSString*)label
{
  return @"Service";
}

+ (NSString*)toolTip
{
  return @"Control MySQL Server Startup and Service.";
}

- (id)initWithOwner: (id<MAdministratorProtocol>)owner
{
  self= [super initWithNibFile: @"ServiceControl" panelOwner: owner];
  
  _defaultFrame= [[self topView] frame];
  
  return self;
}

@end
