#import "MAdministratorController.h"

#import "MAdministrator.h"

#import "MAHomePanel.h"
#import "MAServerInformation.h"
#import "MAUserAdministration.h"
#import "MABackup.h"
#import "MARestore.h"
#import "MAServerLogs.h"
#import "MAServerConnections.h"
#import "MACatalogs.h"
#import "MAHealth.h"
#import "MAServiceControl.h"
#import "MAStartupVariables.h"
#import "MAPreferences.h"

#import <MySQLGUICommon/MConnectionPanel.h>


@interface MAdministratorController(Private)

- (void)applicationWillFinishLaunching:(NSNotification *)aNotification;
- (void)connectionPanel:(MConnectionPanel*)panel finished:(MYSQL*)mysql info:(MYX_USER_CONNECTION*)info;
- (void)connectionPanel:(MConnectionPanel*)panel aborted:(BOOL)error;

@end


@implementation MAdministratorController(Private)

- (void)applicationWillFinishLaunching:(NSNotification *)aNotification
{
  [[MAdministratorController alloc] init];
  
  // register all modules/panels
  MARegisterPanel([MAHomePanel class]);
//  MARegisterPanel([MAServerInformation class]);
  MARegisterPanel([MAServiceControl class]);
  MARegisterPanel([MAStartupVariables class]);
  MARegisterPanel([MAUserAdministration class]);
  MARegisterPanel([MAServerConnections class]);
  MARegisterPanel([MAHealth class]);
  MARegisterPanel([MAServerLogs class]);
  MARegisterPanel([MABackup class]);
  MARegisterPanel([MARestore class]);
  MARegisterPanel([MACatalogs class]);
}

- (void)connectionPanel:(MConnectionPanel*)panel finished:(MYSQL*)mysql info:(MYX_USER_CONNECTION*)info
{
  MAdministrator *admin;
    
  admin= [[MAdministrator alloc] initWithConnection:mysql info:info];
  if (admin)
  {
    [self addInstance: admin];
    [admin show];
    [admin release];
  }
  else
    NSLog(@"Main window initialization failed!");

  [panel release];  
}

- (void)connectionPanel:(MConnectionPanel*)panel aborted:(BOOL)error
{
  [panel release];
}

@end


//=======================================================================

@implementation MAdministratorController


static MAdministratorController *theSharedInstance= nil;


+ (MAdministratorController*)sharedController
{
  if (!theSharedInstance)
    theSharedInstance= [[MAdministratorController alloc] init];
  
  return theSharedInstance;
}


- (id)init
{
  self= [super init];
  if (!self)
    return nil;

  _instances= [[NSMutableArray alloc] init];

  return self;
}


- (void)dealloc
{
  [_instances release];
  [super dealloc];
}


- (void)newDocument: (id)sender
{
  MConnectionPanel *panel;
  
  panel= [[MConnectionPanel alloc] initWithConnectionsFile: 
    [[MAPreferences preferences] pathForFile:@"mysqlx_user_connections.xml"]];
  
  [panel setDelegate:self];
  [panel show];
}


- (void)addInstance: (MAdministrator*)instance
{
  [_instances addObject: instance];
}


@end
