//
//  PrivilegeDataSource.m
//  MySQL Administrator
//
//  Created by Alfredo Kojima on Thu Jul 08 2004.
//  Copyright (c) 2004 MySQL AB. All rights reserved.
//

#import "PrivilegeDataSource.h"

static BOOL has_priv(MYX_USER_OBJECT_PRIVILEGES *privs, const char *priv)
{
  unsigned int i;
  for (i= 0; i < privs->user_privileges_num; i++)
  {
    char *p= strstr(privs->user_privileges[i],"_priv=");
    if (p)
    {
      if (strncasecmp(privs->user_privileges[i], priv, p-(char*)privs->user_privileges[i])==0)
      {
        p= strchr(p, '=');
        if (p)
          return *(p+1)=='Y';
        break;
      }
    }
  }
  return NO;
}

static void set_priv(MYX_USER_OBJECT_PRIVILEGES *privs, const char *priv,
                     BOOL flag)
{
  unsigned int i;
  for (i= 0; i < privs->user_privileges_num; i++)
  {
    char *p= strstr(privs->user_privileges[i],"_priv=");
    if (p)
    {
      if (strncasecmp(privs->user_privileges[i], priv, p-(char*)privs->user_privileges[i])==0)
      {
        p= strchr(p, '=');
        if (p)
        {
          p++;
          g_message("setting privilege %s to %i", priv, flag);
          *p= flag ? 'Y' : 'N';
        }
        break;
      }
    }
  }
}


static BOOL compare_privs(MYX_USER_OBJECT_PRIVILEGES *a, MYX_USER_OBJECT_PRIVILEGES *b)
{
  unsigned int i;
  g_return_val_if_fail(strcmp(a->host, b->host)==0, NO);
  g_return_val_if_fail(strcmp(a->object_name, b->object_name)==0, NO);
  g_return_val_if_fail(a->user_privileges_num==b->user_privileges_num, NO);
  for (i= 0; i < a->user_privileges_num; i++)
  {
    if (strcmp(a->user_privileges[i], b->user_privileges[i])==0)
      return NO;
  }
  return YES;
}





@implementation PrivilegeDataSource

- (void)dealloc
{
  [_allPrivileges release];
  [_assignedPrivileges release];
  [_sourceTable release];
  [super dealloc];
}

- (id)initWithPrivileges: (NSArray*)privileges
             sourceTable: (NSTableView*)table
{
  self= [super init];
  if (self)
  {
    _assignedPrivileges= [[NSMutableArray alloc] init];
    _allPrivileges= [privileges retain];
    _sourceTable= [table retain];
    _privileges= NULL;
  }
  return self;
}

- (void)setPrivileges: (MYX_USER_OBJECT_PRIVILEGES*)objPrivileges
{
  int i, c= [_allPrivileges count];
  _privileges= objPrivileges;
  [_assignedPrivileges removeAllObjects];
  if (_privileges)
  {
    for (i= 0; i < c; i++)
    {
      NSString *p= [_allPrivileges objectAtIndex:i];
      if (has_priv(_privileges, [p UTF8String]))
        [_assignedPrivileges addObject: p];
    }
  }
}

- (void)revoke: (NSString*)priv
{
  NSAssert(_privileges, @"Privilege datasource is not initialized with user's privilege structure");
  NSLog(@"revoke %@", priv);
  set_priv(_privileges, [priv UTF8String], NO);
  [_assignedPrivileges removeObjectIdenticalTo: priv];
  if ([_assignedPrivileges indexOfObjectIdenticalTo: priv]!=NSNotFound)
    NSLog(@"SHI TCOUDLTN REMOVE");
}

- (void)grant: (NSString*)priv
{
  NSAssert(_privileges, @"Privilege datasource is not initialized with user's privilege structure");
  NSLog(@"grant %@", priv);
  NSAssert([_assignedPrivileges indexOfObjectIdenticalTo:priv]==NSNotFound,@"Granting duplicated privlege");
  set_priv(_privileges, [priv UTF8String], YES);
  [_assignedPrivileges addObject: priv];
}

- (int)numberOfRowsInTableView:(NSTableView *)aTableView
{
  if (_sourceTable == aTableView)
    return [_allPrivileges count] - [_assignedPrivileges count];
  else
    return [_assignedPrivileges count];
}


- (id)tableView:(NSTableView *)aTableView objectValueForTableColumn:(NSTableColumn *)aTableColumn 
            row:(int)rowIndex
{
  if (_sourceTable == aTableView)
  {
    int c= [_allPrivileges count];
    int j;
    int d= rowIndex;
    for (j= 0; j < c; j++)
    {
      NSString *s= [_allPrivileges objectAtIndex:j];
      if ([_assignedPrivileges indexOfObjectIdenticalTo:s]==NSNotFound)
      {
        if (d == 0)
        {
          if (!aTableColumn || [[aTableColumn identifier] isEqualToString:@"privilege"])
            return s;
          else
            return [NSString stringWithFormat:@"Grants the %@ privilege to the user.",s];
        }
        --d;
      }
    }
  }
  else if (_privileges)
  {
    return [_assignedPrivileges objectAtIndex: rowIndex];
  }
  return @"?";
}

@end
