/* MConnectionPanel */

#import <Cocoa/Cocoa.h>

#include <myx_public_interface.h>

@interface MConnectionPanel : NSWindowController
{
  @protected
    IBOutlet NSButton *connectButton;
    IBOutlet NSPopUpButton *connectionPopUp;
    IBOutlet NSButton *detailsButton;
    IBOutlet NSPanel *errorPanel;
    IBOutlet NSTextField *errorText;
    IBOutlet NSTextField *hostname;
    IBOutlet NSSecureTextField *password;
    IBOutlet NSButton *pingButton;
    IBOutlet NSTextView *pingText;
    IBOutlet NSTextField *port;
    IBOutlet NSStepper *portSpin;
    IBOutlet NSProgressIndicator *progressIndicator;
    IBOutlet NSTextField *username;
    IBOutlet NSView *extraView;
    
    id _delegate;
    
    MYSQL *_mysql;
    BOOL _connecting;
    BOOL _connectionFailed; // written by thread
    NSString *_connectionsFile;
    MYX_USER_CONNECTIONS *_connections;
    MYX_USER_CONNECTION _new_connection;
}
- (IBAction)cancel:(id)sender;
- (IBAction)closeErrorPanel:(id)sender;
- (IBAction)connect:(id)sender;
- (IBAction)connectionChanged:(id)sender;
- (IBAction)pingHost:(id)sender;
- (IBAction)toggleDetails:(id)sender;

- (id)initWithConnectionsFile:(NSString*)file; //

- (void)setDelegate:(id)deleg;

- (void)show;

@end
