//
//  MSchemaDataSource.h
//  MySQLGUICommon
//
//  Created by Alfredo Kojima on Sun Jun 27 2004.
//  Copyright (c) 2004 MySQL AB. All rights reserved.
//

#import <Foundation/Foundation.h>
#include "myx_public_interface.h"


typedef enum {
  MCatalogItemType,
  MSchemaItemType,
  MTableItemType,
  MColumnItemType
} MSchemaDSItemType;

@class NSImage;

@interface MSchemaItem : NSObject {
@public
  MSchemaDSItemType type;
  NSImage *icon;
  MSchemaItem *parent;
@protected
  union {
    MYX_CATALOG *catalog;
    MYX_SCHEMA *schema;
    MYX_SCHEMA_TABLE *table;
    MYX_SCHEMA_TABLE_COLUMN *column;
  } _object;
  NSString *_repr;
  NSMutableArray *_children; //nil means retrieve pending
}

- (id)initWithCatalog: (MYX_CATALOG*)catalog
                 icon: (NSImage*)icon;
- (id)initWithSchema: (MYX_SCHEMA*)schema
                icon: (NSImage*)icon;
- (id)initWithTable: (MYX_SCHEMA_TABLE*)table
               icon: (NSImage*)icon;
- (id)initWithColumn: (MYX_SCHEMA_TABLE_COLUMN*)column
                icon: (NSImage*)icon;

- (void)dealloc;

- (MSchemaItem*)findChild: (NSString*)name;
- (NSMutableArray*)children;
- (void)setChildren: (NSMutableArray*)children;

- (NSString*)repr;
- (NSImage*)icon;

- (MYX_CATALOG*)catalog;
- (MYX_SCHEMA*)schema;
- (MYX_SCHEMA_TABLE*)table;
- (MYX_SCHEMA_TABLE_COLUMN*)column;

@end


@interface MSchemaDataSource : NSObject {
  MSchemaDSItemType _rootType;
  MSchemaDSItemType _leafType;

  id _tableFetcher;
  SEL _tableFetcherAction;
  
  NSMutableArray *_rows;
}

- (id)initWithRoot: (MSchemaDSItemType)root
              leaf: (MSchemaDSItemType)leaf;
- (void)dealloc;

- (void)setRootList: (NSMutableArray*)array;
- (NSMutableArray*)rootList;

- (void)setTableFetcher: (id)target selector:(SEL)sel;

- (MSchemaItem*)findItem: (NSString*)name;

- (id)outlineView:(NSOutlineView *)outlineView 
            child:(int)index 
           ofItem:(id)item;

- (BOOL)outlineView:(NSOutlineView *)outlineView 
   isItemExpandable:(id)item;

- (int)outlineView:(NSOutlineView *)outlineView 
numberOfChildrenOfItem:(id)item;

- (id)outlineView:(NSOutlineView *)outlineView 
objectValueForTableColumn:(NSTableColumn *)tableColumn 
           byItem:(id)item;

@end
