unit Find;

interface                          

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, ComCtrls;

type
  TSyntaxFindDialog = class(TForm)
    FindTextComboBox: TComboBox;
    Label1: TLabel;
    CancelButton: TBitBtn;
    AllButton: TBitBtn;
    GroupBox1: TGroupBox;
    CaseCheckBox: TCheckBox;
    WholeWordCheckBox: TCheckBox;
    NonSpacingCheckBox: TCheckBox;
    GroupBox2: TGroupBox;
    ForwardRadioButton: TRadioButton;
    BackwardRadioButton: TRadioButton;
    GroupBox3: TGroupBox;
    GlobalRadioButton: TRadioButton;
    SelectedRadioButton: TRadioButton;
    GroupBox4: TGroupBox;
    RadioButton5: TRadioButton;
    HomeRadioButton: TRadioButton;
    Label2: TLabel;
    NewTextComboBox: TComboBox;
    OKButton: TBitBtn;
    CompressCheckBox: TCheckBox;
    GroupBox5: TGroupBox;
    SearchRadioButton: TRadioButton;
    ReplaceRadioButton: TRadioButton;
    StatusBar1: TStatusBar;
    PromptCheckBox: TCheckBox;
    RECheckBox: TCheckBox;
    procedure AllButtonClick(Sender: TObject);
    procedure RECheckBoxClick(Sender: TObject);
    procedure ReplaceRadioButtonClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FindTextComboBoxChange(Sender: TObject);
  end;

var
  SyntaxFindDialog: TSyntaxFindDialog;

//----------------------------------------------------------------------------------------------------------------------

implementation

uses
  CommCtrl;

{$R *.DFM}

//----------------------------------------------------------------------------------------------------------------------

procedure TSyntaxFindDialog.AllButtonClick(Sender: TObject);

var
  Index: Integer;
  Text: String;

begin
  Text := FindTextComboBox.Text;
  Index := FindTextComboBox.Items.IndexOf(FindTextComboBox.Text);
  if Index > -1 then FindTextComboBox.Items.Delete(Index);
  FindTextComboBox.Items.Insert(0, Text);
  FindTextComboBox.ItemIndex := 0;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TSyntaxFindDialog.RECheckBoxClick(Sender: TObject);

// need to indicate specific features when the user want to search using
// regular expressions, as we cannot search backward then and not whole words

begin
  CompressCheckBox.Enabled := not RECheckBox.Checked;
  WholeWordCheckBox.Enabled := not RECheckBox.Checked;
  ForwardRadioButton.Enabled := not RECheckBox.Checked;
  BackwardRadioButton.Enabled := not RECheckBox.Checked;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TSyntaxFindDialog.ReplaceRadioButtonClick(Sender: TObject);

begin
  NewTextComboBox.Enabled := ReplaceRadioButton.Checked;
  Label2.Enabled := ReplaceRadioButton.Checked;
  AllButton.Enabled := ReplaceRadioButton.Checked;
  PromptCheckbox.Enabled := ReplaceRadioButton.Checked;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TSyntaxFindDialog.FormActivate(Sender: TObject);

begin
  ReplaceRadioButtonClick(nil);
  FindTextComboBoxChange(nil);
  ActiveControl := FindTextComboBox;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TSyntaxFindDialog.FindTextComboBoxChange(Sender: TObject);

begin
  OKButton.Enabled := FindTextComboBox.Text <> '';
  AllButton.Enabled := OKButton.Enabled and ReplaceRadioButton.Checked;
end;

//----------------------------------------------------------------------------------------------------------------------

end.
