// test_restore_backup.cpp : Defines the entry point for the console application.
//

#include "stdio.h"
#include "stdlib.h"
#include "myx_admin_public_interface.h"

const char * filename;
const char * charset;
const char * connection_filename;
const char * content_filename;
const char * target_schema;
int interval;
const char * path_to_log;
const char * cruser_data;
const char * path_to_wlog;
const char * cwuser_data;

void print_usage()
{
  printf(
    "usage : test_restore_backup.exe <connection_filename> <filename>\n"
    " <charset> <content_filename> <target_schema> <interval> "
    " <path_to_log> <ruser_data> <path_to_warning_log> <wuser_data>\n");
}

FILE * progress_log_file= 0;
FILE * warnings_log_file= 0;

int progress_report_restore(bigint bytes_read, bigint bytes_total,
                            void *user_data)
{
  fprintf(progress_log_file,"read %ld bytes of %ld, user_data=\"%s\"\n",
          (long int)bytes_read,(long int)bytes_total,user_data);
  return 0;
}

void report_restore_warning(const char *msg, void *user_data)
{
  fprintf(warnings_log_file,"msg=\"%s\", user_data=\"%s\"\n",msg,user_data);
}

int test_with_everything(MYSQL * mysql, MYX_BACKUP_PROFILE * profile)
{
  MYX_BACKUP_ERROR err= myx_restore_backup(mysql,filename,charset,
                                           profile->backup_content,"def",
                                           target_schema,
                                           MYX_BT_SQL_SCRIPT,
                                           profile->options,interval,
                                           progress_report_restore,
                                           (void*)cruser_data,
                                           report_restore_warning,
                                           (void*)cwuser_data);
  if (err==MYX_BACKUP_NO_ERROR)
  {
    return 0;
  }
  else
  {
    fprintf(stderr,"myx_restore_backup returned error=%d\n",
            (int)err);
    if (err==MYX_BACKUP_MYSQL_ERROR)
    {
      fprintf(stderr,"myx_mysql_errno=%d, myx_mysql_error=\"%s\"\n",
              myx_mysql_errno(mysql),myx_mysql_error(mysql));
    }
    return err;
  }
}

int test_with_mysql_profile(MYSQL * mysql, MYX_BACKUP_PROFILE * profile)
{
  progress_log_file= fopen(path_to_log,"w");
  if (!progress_log_file)
  {
    printf("can't open log file \"%s\"\n",path_to_log);
    return -1;
  }
  else
  {
    warnings_log_file= fopen(path_to_wlog,"w");
    if (!warnings_log_file)
    {
      fclose(progress_log_file);
      printf("can't open warning log file \"%s\"\n",path_to_wlog);
      return -1;
    }
    else
    {
      int res= test_with_everything(mysql,profile);
      fclose(progress_log_file);
      fclose(warnings_log_file);
      return res;
    }
  }
}

int test_with_mysql(MYSQL * mysql)
{
  MYX_ADMIN_LIB_ERROR err;
  MYX_BACKUP_PROFILE * profile= myx_load_profile(content_filename,"",&err);
  
  int res;
  if (profile)
  {
    res= test_with_mysql_profile(mysql,profile);
  }
  else
  {
    fprintf(stderr,"can't read backup_profile from file \"%s\", error=%d\n",
            content_filename,(int)err);
    res= -1;
  }

  myx_free_profile(profile);
  return res;
}

int test_with_connecton(MYX_USER_CONNECTION * user_conn)
{
  char * var;
  if ((var= getenv("my_cnf_path")))
    myx_set_my_cnf_path(var);

  MYSQL * mysql= myx_mysql_init();
  if (!mysql)
  {
    fprintf(stderr,"can't init mysql!\n");
    return -1;
  }
  else
  {
    int res;
    if (!myx_connect_to_instance(user_conn,mysql))
    {
      res= test_with_mysql(mysql);
    }
    else
    {
      fprintf(stderr,"can't connect to mysql!\n");
      res= -1;
    }
    myx_mysql_close(mysql);
    return res;
  }
}

int main(int argc, char* argv[])
{
  if (argc<11)
  {
    print_usage();
    return 0;
  }
  else
  {
    connection_filename=   argv[1];
    filename=              argv[2];
    charset=               argv[3];
    content_filename=      argv[4];
    target_schema= !strcmp(argv[5],"0") ? 0 : argv[5];
    interval=         atoi(argv[6]);
    path_to_log=           argv[7];
    cruser_data=           argv[8];
    path_to_wlog=          argv[9];
    cwuser_data=           argv[10];

    MYX_LIB_ERROR err;
    MYX_USER_CONNECTIONS * connections=
                           myx_load_user_connections(connection_filename,&err);
    if (!connections)
    {
      fprintf(stderr,"Can't read connection file \"%s\", error=%d\n",
              connection_filename,(int)err);
      return -1;
    }
    else
    {
      int res;
      if (connections->user_connections_num)
      {
        res= test_with_connecton(connections->user_connections);
      }
      else
      {
        fprintf(stderr,"there aren't connections in the connection file\n");
        res= -1;
      }
      myx_free_user_connections(connections);
      return res;
    }
  }
}
