unit AdminCatalog;

interface

uses
  gnugettext, Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls, ComCtrls, InstanceSections, Buttons,
  Contnrs, Menus, AuxFuncs, myx_public_interface, AdvancedEdit,
  SchemataTreeView, MySQLConnection, AdditionalClasses,
  AdminCatalogTableCheck, Options, MyxError,
  EditorTable, TntMenus, VirtualTrees, PNGImage, ImgList,
  CommonFuncs, Math, TntExtCtrls, TntComCtrls, TntStdCtrls, TntForms,
  TntClasses, MySQLCommonFuncs;

type
  TAdminCatalogForm = class(TInstanceSectionForm)
    SubTreePnl: TTntPanel;
    Splitter1: TTntSplitter;
    CatalogPnl: TTntPanel;
    CatalogPageControl: TTntPageControl;
    CatalogSheet: TTabSheet;
    SchemaSheet: TTabSheet;
    TopPnl: TTntPanel;
    SchemaPageControl: TTntPageControl;
    TablesTabSheet: TTabSheet;
    IndicesTabSheet: TTabSheet;
    StoredProcTabSheet: TTabSheet;
    DevDocTabSheet: TTabSheet;
    UsersTabSheet: TTabSheet;
    Panel3: TTntPanel;
    Panel5: TTntPanel;
    TablesTitleLbl: TTntLabel;
    TableHeaderImg: TTntImage;
    Panel1: TTntPanel;
    IndicesTitleLbl: TTntLabel;
    IndexHeaderImg: TTntImage;
    Panel2: TTntPanel;
    StoredProcBevel: TTntBevel;
    StoredProcTitleLbl: TTntLabel;
    Image2: TTntImage;
    Panel4: TTntPanel;
    DevDocBevel: TTntBevel;
    DevObjTitleLbl: TTntLabel;
    Image4: TTntImage;
    Panel6: TTntPanel;
    UsersBevel: TTntBevel;
    UsersTitleLbl: TTntLabel;
    Image5: TTntImage;
    Panel7: TTntPanel;
    StoredProcListView: TTntListView;
    Panel10: TTntPanel;
    Panel11: TTntPanel;
    Button3: TTntButton;
    Button5: TTntButton;
    Button6: TTntButton;
    Button9: TTntButton;
    DevDocTreeView: TTntTreeView;
    DevDocTreeViewHeaderControl: THeaderControl;
    Panel12: TTntPanel;
    Panel13: TTntPanel;
    Button10: TTntButton;
    Button11: TTntButton;
    Button12: TTntButton;
    Button13: TTntButton;
    UsersListView: TTntListView;
    TablesOptionsPageControl: TTntPageControl;
    TabSheet2: TTabSheet;
    GroupBox2: TTntGroupBox;
    Label27: TTntLabel;
    RowFormatLbl: TTntLabel;
    TableTypeLbl: TTntLabel;
    Label24: TTntLabel;
    Label40: TTntLabel;
    AutoIncLbl: TTntLabel;
    Label48: TTntLabel;
    CreateOptionsLbl: TTntLabel;
    ViewsTabSheet: TTabSheet;
    Panel14: TTntPanel;
    ViewsBevel: TTntBevel;
    ViewsTitleLbl: TTntLabel;
    Image6: TTntImage;
    ViewsListView: TTntListView;
    Panel15: TTntPanel;
    Panel16: TTntPanel;
    Button14: TTntButton;
    Button15: TTntButton;
    Button16: TTntButton;
    Button17: TTntButton;
    SelectSchemaLbl: TTntLabel;
    TabSheet3: TTabSheet;
    GroupBox3: TTntGroupBox;
    Label28: TTntLabel;
    RowsLbl: TTntLabel;
    AvgRowLengthLbl: TTntLabel;
    Label31: TTntLabel;
    Label32: TTntLabel;
    DataLengthLbl: TTntLabel;
    Label34: TTntLabel;
    MaxDataLenLbl: TTntLabel;
    Label36: TTntLabel;
    IndexLenLbl: TTntLabel;
    Label38: TTntLabel;
    DataFreeLbl: TTntLabel;
    TableTimeGBox: TTntGroupBox;
    Label2: TTntLabel;
    TblCreateTimeLbl: TTntLabel;
    Label4: TTntLabel;
    TblUpdateTimeLbl: TTntLabel;
    Label6: TTntLabel;
    TblCheckTimeLbl: TTntLabel;
    EventsTabSheet: TTabSheet;
    Panel17: TTntPanel;
    EventsBevel: TTntBevel;
    EventsTitleLbl: TTntLabel;
    Image7: TTntImage;
    TablesSchemaLbl: TTntLabel;
    IndicesSchemaLbl: TTntLabel;
    SchemataFrame: TSchemataFrame;
    ListView1: TTntListView;
    ThreadsBevel: TTntBevel;
    TableInfoSplitter: TTntSplitter ;
    CheckTablesBtn: TTntButton;
    RefreshBtn: TTntButton;
    Label1: TTntLabel;
    Label9: TTntLabel;
    AddTableBtn: TTntButton;
    Button1: TTntButton;
    TablesPopupMenu: TTntPopupMenu;
    EditTableMI: TTntMenuItem;
    CreateTableMI: TTntMenuItem;
    N1: TTntMenuItem;
    DropTableMI: TTntMenuItem;
    OptimizeTableMI: TTntMenuItem;
    CheckTableMI: TTntMenuItem;
    RepairTableMI: TTntMenuItem;
    N2: TTntMenuItem;
    RefreshMI: TTntMenuItem;
    TableDetailsBtn: TTntButton;
    EditTableBtn: TTntButton;
    TableMaintenanceMI: TTntMenuItem;
    TablesVST: TVirtualStringTree;
    TableSumPnl: TTntPanel;
    Image3: TTntImage;
    NumberOfTablesLbl: TTntLabel;
    NumberOfTablesCaptionLbl: TTntLabel;
    RowsCountLbl: TTntLabel;
    RowsCountCaptionLbl: TTntLabel;
    Image8: TTntImage;
    Image9: TTntImage;
    TableDataLenCaptionLbl: TTntLabel;
    TableDataLenLbl: TTntLabel;
    TableIndexLenCaptionLbl: TTntLabel;
    TableIndexLenLbl: TTntLabel;
    Image10: TTntImage;
    AssetSheet: TTabSheet;
    TablenamePnl: TTntPanel;
    TablenameLbl: TTntLabel;
    TableImg: TTntImage;
    TableCommentLbl: TTntLabel;
    Label3: TTntLabel;
    IndicesVST: TVirtualStringTree;
    Bevel1: TTntBevel;
    RefreshIndicesBtn: TTntButton;
    Panel8: TTntPanel;
    Image1: TTntImage;
    Image11: TTntImage;
    Image12: TTntImage;
    NumberOfIndicesLbl: TTntLabel;
    NumberOfIndicesCaptionLbl: TTntLabel;
    IndexColCountLbl: TTntLabel;
    Label10: TTntLabel;
    Image13: TTntImage;
    Label11: TTntLabel;
    IndexUniqueCountLbl: TTntLabel;
    Label13: TTntLabel;
    IndexNotNullCountLbl: TTntLabel;
    EditTableDataMI: TTntMenuItem;

    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure CatalogPnlResize(Sender: TObject);

    procedure SchemaPageControlChange(Sender: TObject);
    procedure DevDocTreeViewAdvancedCustomDrawItem(Sender: TCustomTreeView;
      Node: TTreeNode; State: TCustomDrawState; Stage: TCustomDrawStage;
      var PaintImages, DefaultDraw: Boolean);
    procedure DevDocTreeViewHeaderControlSectionResize(
      HeaderControl: THeaderControl; Section: THeaderSection);

    procedure BuildSchemaPages(Schema: TMYX_SCHEMA = nil);
    procedure SchemataTreeAdvEditSeachEdChange(Sender: TObject);
    procedure SchemataFrameSchemaTreeViewChange(Sender: TObject;
      Node: TTntTreeNode);
    procedure TablesOptionsPageControlChange(Sender: TObject);

    procedure FetchSchemaTableStatus(Sender: TObject);
    procedure FetchedSchemaTableStatus(Sender: TObject);
    procedure ClearTableInfos;
    procedure ClearControls;

    procedure Disconnected(var Message: TMessage); message WM_Disconnected;
    procedure Reconnected(var Message: TMessage); message WM_Reconnected;
    procedure SchemaListChanged(var Message: TMessage); message WM_SchemaListChanged;
    procedure CheckTablesBtnClick(Sender: TObject);
    procedure SchemataFrameRefreshCatalogsSchemataListMIClick(
      Sender: TObject);
    procedure RefreshBtnClick(Sender: TObject);
    procedure EditTableMIClick(Sender: TObject);
    procedure CreateTableMIClick(Sender: TObject);

    procedure ShowHideTableDetails;
    procedure TableDetailsBtnClick(Sender: TObject);
    procedure TablesVSTGetText(Sender: TBaseVirtualTree;
      Node: PVirtualNode; Column: TColumnIndex; TextType: TVSTTextType;
      var CellText: WideString);
    procedure TablesVSTHeaderClick(Sender: TVTHeader; Column: TColumnIndex;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure TablesVSTCompareNodes(Sender: TBaseVirtualTree; Node1,
      Node2: PVirtualNode; Column: TColumnIndex; var Result: Integer);
    procedure TablesVSTDblClick(Sender: TObject);
    procedure TablesVSTKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure TablesVSTChange(Sender: TBaseVirtualTree;
      Node: PVirtualNode);
    procedure TablesVSTAfterCellPaint(Sender: TBaseVirtualTree;
      TargetCanvas: TCanvas; Node: PVirtualNode; Column: TColumnIndex;
      CellRect: TRect);
    procedure TablesVSTGetImageIndex(Sender: TBaseVirtualTree;
      Node: PVirtualNode; Kind: TVTImageKind; Column: TColumnIndex;
      var Ghosted: Boolean; var ImageIndex: Integer);
    procedure TablesVSTAfterItemErase(Sender: TBaseVirtualTree;
      TargetCanvas: TCanvas; Node: PVirtualNode; ItemRect: TRect);
    procedure PaintNodeBKBarGraph(TargetCanvas: TCanvas;
      Node: PVirtualNode; Column: integer; ItemRect: TRect;
      Width: integer; PenColor: TColor; BrushColor: TColor);

    procedure EditTable(Catalog: WideString;
      Schema: WideString; Table: WideString);
    procedure EditorTableClose(Sender: TObject);
    procedure DropTableMIClick(Sender: TObject);
    procedure IndicesVSTGetText(Sender: TBaseVirtualTree;
      Node: PVirtualNode; Column: TColumnIndex; TextType: TVSTTextType;
      var CellText: WideString);
    procedure IndicesVSTAfterCellPaint(Sender: TBaseVirtualTree;
      TargetCanvas: TCanvas; Node: PVirtualNode; Column: TColumnIndex;
      CellRect: TRect);
    procedure IndicesVSTGetImageIndex(Sender: TBaseVirtualTree;
      Node: PVirtualNode; Kind: TVTImageKind; Column: TColumnIndex;
      var Ghosted: Boolean; var ImageIndex: Integer);
    procedure IndicesVSTMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure IndicesVSTCompareNodes(Sender: TBaseVirtualTree; Node1,
      Node2: PVirtualNode; Column: TColumnIndex; var Result: Integer);

    procedure EditorTableApplyedChanges(Sender: TObject);
    procedure SchemataFrameSchemaTreeViewChanging(Sender: TObject;
      Node: TTntTreeNode; var AllowChange: Boolean);
    procedure EditTableDataMIClick(Sender: TObject);
    procedure DoSchemaTreeReloaded(Sender: TObject);
    procedure SchemataFrameCatalogVSTFocusChanging(
      Sender: TBaseVirtualTree; OldNode, NewNode: PVirtualNode; OldColumn,
      NewColumn: TColumnIndex; var Allowed: Boolean);
    procedure SchemataFrameCatalogVSTFocusChanged(Sender: TBaseVirtualTree;
      Node: PVirtualNode; Column: TColumnIndex);
    procedure SchemataFrameCreateNewSchemaMIClick(Sender: TObject);
    procedure SchemataFrameCopyAssetSQLMIClick(Sender: TObject);
  private
    { Private declarations }
    CurrentSchema: TMYX_SCHEMA;
    CurrentTableList: TMYX_SCHEMA_TABLE_STATUS;
    CurrentSchemaDataLen,
    CurrentSchemaIndexLen: int64;

    ShowTableDetails: Boolean;

    TreeBtnClosedPNGImg,
    TreeBtnOpenPNGImg,
    TablePNGImg,
    TableHeaderPNGImg,
    IndexPNGImg,
    IndexHeaderPNGImg,
    ColumnPNGImg,
    ColumnPKPNGImg: TPNGObject;

    TreeSpacerImgList: TImageList;
  public
    { Public declarations }
    AdminCatalogTableCheckForm: TAdminCatalogTableCheckForm;

    EditorTableForm: TEditorTableForm;
  end;

  PIndexNodeData= ^IndexNodeData;
  IndexNodeData = record
    Table: TMYX_TABLE_STATUS;
    Index: TMYX_TABLE_INDEX;
    Column: TMYX_TABLE_INDEX_COLUMN;
  end;

var
  AdminCatalogForm: TAdminCatalogForm;

implementation

uses
  Main, ApplicationDataModule, PNGTools;

{$R *.dfm}

procedure TAdminCatalogForm.FormCreate(Sender: TObject);
begin
  InitForm(self);

  SchemataFrame.MySQLConnection := MySQLConn;
  SchemataFrame.ShowSchemaAssets:=False;

  DockedPanel:=CatalogPnl;
  SubTreePanel:=SubTreePnl;

  //Init PageControls
  CatalogPageControl.ActivePageIndex:=0;
  SchemaPageControl.ActivePageIndex:=0;
  TablesOptionsPageControl.ActivePageIndex:=0;

  //Hide CatalogPageControl Buttons
  TopPnl.Height:=9;

  CurrentSchema:=nil;
  CurrentTableList:=nil;

  EditorTableForm:=nil;

  AdminCatalogTableCheckForm:=nil;

  //For MySQL Versions < 5 hide Views, StoredProcedures and Events
  ViewsTabSheet.TabVisible:=False;
  StoredProcTabSheet.TabVisible:=False;
  EventsTabSheet.TabVisible:=False;
  DevDocTabSheet.TabVisible:=False;
  UsersTabSheet.TabVisible:=False;

  SchemataFrame.FillSchemaTree;
  SchemataFrame.OnCreateTable:=CreateTableMIClick;
  SchemataFrame.OnSchemaTreeReloaded:=DoSchemaTreeReloaded;

  if(MYXCommonOptions.XPStyleEnabled)then
    TableInfoSplitter.Color:=clWhite;

  CurrentSchemaDataLen:=0;

  TreeBtnClosedPNGImg:=LoadPNGImageFromResource('tree_button_closed');
  TreeBtnOpenPNGImg:=LoadPNGImageFromResource('tree_button_open');
  TablePNGImg:=LoadPNGImageFromResource('asset_table_16x16', TableImg);
  TableHeaderPNGImg:=LoadPNGImageFromResource('asset_table', TableHeaderImg);
  IndexPNGImg:=LoadPNGImageFromResource('asset_index_16x16');
  IndexHeaderPNGImg:=LoadPNGImageFromResource('asset_index', IndexHeaderImg);
  ColumnPNGImg:=LoadPNGImageFromResource('column');
  ColumnPKPNGImg:=LoadPNGImageFromResource('column_pk');


  //Disable Users for now
  DisableEnableControls(UsersTabSheet, False);

  ShowTableDetails:=False;
  ShowHideTableDetails;

  TreeSpacerImgList:=GetTransparentImgList(6);
  IndicesVST.Images:=TreeSpacerImgList;

  //Enable Menu Items
  EditTableDataMI.Enabled:=(GetMySQLQueryBrowserCmd<>'');
end;

procedure TAdminCatalogForm.FormDestroy(Sender: TObject);
begin
  if(EditorTableForm<>nil)then
    EditorTableForm.Free;

  TablePNGImg.Free;
  TableHeaderPNGImg.Free;
  IndexPNGImg.Free;
  IndexHeaderPNGImg.Free;
  ColumnPNGImg.Free;
  ColumnPKPNGImg.Free;

  TreeSpacerImgList.Free;
end;

procedure TAdminCatalogForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  //AdminCatalogTableCheckForm.Close;

  Action:=caFree;
end;

procedure TAdminCatalogForm.CatalogPnlResize(Sender: TObject);
var InitSheetWidth, InitSheetHeight: integer;
begin
  //Position Catalog PageControl
  CatalogPageControl.Top:=0;
  CatalogPageControl.Left:=0;
  CatalogPageControl.Width:=CatalogPnl.Width;
  CatalogPageControl.Height:=CatalogPnl.Height;

  SelectSchemaLbl.Width:=CatalogPnl.Width-591+555;
  SelectSchemaLbl.Top:=CatalogPnl.Height div 2-18;

  //Size Schema PageControl
  SchemaPageControl.Width:=SchemaSheet.Width-583+569;
  SchemaPageControl.Height:=SchemaSheet.Height-487+479;

  InitSheetWidth:=561; //of SchemaPageControl
  InitSheetHeight:=451;

  //Views TabSheet
  ViewsBevel.Width:=IndicesTabSheet.Width-InitSheetWidth+535;

  ViewsListView.Width:=IndicesTabSheet.Width-InitSheetWidth+535;
  ViewsListView.Height:=IndicesTabSheet.Height-InitSheetHeight+349;

  //StoredProc TabSheet
  StoredProcBevel.Width:=StoredProcTabSheet.Width-InitSheetWidth+535;

  StoredProcListView.Width:=StoredProcTabSheet.Width-InitSheetWidth+535;
  StoredProcListView.Height:=StoredProcTabSheet.Height-InitSheetHeight+349;

  //Events TabSheet
  EventsBevel.Width:=StoredProcTabSheet.Width-InitSheetWidth+535;

  //DevDoc TabSheet
  DevDocBevel.Width:=DevDocTabSheet.Width-InitSheetWidth+535;

  DevDocTreeView.Width:=DevDocTabSheet.Width-InitSheetWidth+535;
  DevDocTreeView.Height:=DevDocTabSheet.Height-InitSheetHeight+349;

  DevDocTreeViewHeaderControl.Width:=DevDocTabSheet.Width-InitSheetWidth+516;

  //Users TabSheet
  UsersBevel.Width:=UsersTabSheet.Width-InitSheetWidth+535;

  {UsersListView.Width:=UsersTabSheet.Width-InitSheetWidth+535;
  UsersListView.Height:=UsersTabSheet.Height-InitSheetHeight+349;}
end;

procedure TAdminCatalogForm.SchemaPageControlChange(Sender: TObject);
begin
  CatalogPnlResize(self);

  //Select Node in Schema tree, also
  //For MySQL Versions < 5 hide Views, StoredProcedures and Events
  {if(InstanceDM.MySQLMajorVersion<5)and(SchemaPageControl.ActivePageIndex>1)then
    SchemaTreeView.Selected:=CurrentSchemaNodes[SchemaPageControl.ActivePageIndex+1-3]
  else
    SchemaTreeView.Selected:=CurrentSchemaNodes[SchemaPageControl.ActivePageIndex+1];}
end;

procedure TAdminCatalogForm.DevDocTreeViewAdvancedCustomDrawItem(
  Sender: TCustomTreeView; Node: TTreeNode; State: TCustomDrawState;
  Stage: TCustomDrawStage; var PaintImages, DefaultDraw: Boolean);
var NodeRect: TRect;
  XPos: integer;
  theHeaderControl: THeaderControl;
  i: integer;
begin
  if(TTntTreeView(Sender).Name='TableIndexTreeView')then
    theHeaderControl:=DevDocTreeViewHeaderControl
  else
    theHeaderControl:=nil;

  if(Stage=cdPrePaint)then
  begin
    Sender.Canvas.Pen.Style:=psSolid;
    if(cdsFocused in State)then
      Sender.Canvas.Pen.Color:=clGray
    else
      Sender.Canvas.Pen.Color:=clSilver;

    NodeRect:=Node.DisplayRect(False);

    if(cdsSelected in State)then
    begin
      Sender.Canvas.Brush.Color:=clSilver;
      Sender.Canvas.Pen.Color:=clGray;
      Sender.Canvas.Rectangle(NodeRect.Left+19+Node.Level*19+5-2, NodeRect.Top,
        Sender.Width-4-18, NodeRect.Bottom);
    end
    else
    begin
      Sender.Canvas.Brush.Color:=clWhite;
      Sender.Canvas.FillRect(Rect(NodeRect.Left{+19}+Node.Level*19+5-2, NodeRect.Top,
        Sender.Width-4-18, NodeRect.Bottom+1));
    end;

    Sender.Canvas.Brush.Color:=clWhite;

    DefaultDraw:=True;
  end
  else if(Stage=cdPostPaint)then
  begin
    if(Node.Data<>nil)then
    begin
      NodeRect:=Node.DisplayRect(False);

      if(cdsFocused in State)then
      begin
        Sender.Canvas.Pen.Color:=clGray;
        Sender.Canvas.Pen.Style:=psSolid;
        Sender.Canvas.Brush.Color:=clSilver;

        Sender.Canvas.Rectangle(NodeRect.Left+19+Node.Level*19+5-2, NodeRect.Top,
          Sender.Width-4-18, NodeRect.Bottom);

        Sender.Canvas.Brush.Style:=bsClear;

        Sender.Canvas.TextRect(Rect(
          NodeRect.Left+19+Node.Level*19+5, NodeRect.Top+1,
          theHeaderControl.Sections[0].Width+2, NodeRect.Top+16),
          NodeRect.Left+19+Node.Level*19+5, NodeRect.Top+1,
          Node.Text);
      end;

      XPos:=0;
      for i:=0 to theHeaderControl.Sections.Count-2 do
      begin
        XPos:=XPos+theHeaderControl.Sections[i].Width;

        if(TTntTreeView(Sender).Name='IndexTreeView')or
          (TTntTreeView(Sender).Name='TableIndexTreeView')then
        begin
          if(Node.Data<>nil)then
            if(i<TTntStringList(Node.Data).Count)then
              Sender.Canvas.TextRect(Rect(XPos+2, NodeRect.Top+1,
                XPos+theHeaderControl.Sections[i+1].Width-4, NodeRect.Top+16),
                XPos+2, NodeRect.Top+1,
                TTntStringList(Node.Data)[i]);
        end
        else
          Sender.Canvas.TextOut(XPos+2, NodeRect.Top+2, TDevDocNode(Node.Data).GetSubItems[i]);
      end;
    end;
  end;
end;

procedure TAdminCatalogForm.DevDocTreeViewHeaderControlSectionResize(
  HeaderControl: THeaderControl; Section: THeaderSection);
begin
  DevDocTreeView.Invalidate;
end;

procedure TAdminCatalogForm.SchemataTreeAdvEditSeachEdChange(
  Sender: TObject);
begin
  SchemataTreeAdvEditSeachEdChange(Sender);

  //if there is no Node selected
  if(SchemataFrame.CatalogVST.SelectedCount=0)then
    CatalogPageControl.ActivePageIndex:=0;
end;

procedure TAdminCatalogForm.SchemataFrameSchemaTreeViewChange(
  Sender: TObject; Node: TTntTreeNode);
begin

  if(Node<>nil)then
    if(Node.Data<>nil)then
    begin
      if(TObject(Node.Data) is TMYX_CATALOG)then
        CatalogPageControl.ActivePage:=CatalogSheet
      else if(TObject(Node.Data) is TMYX_SCHEMA)then
      begin
        CatalogPageControl.ActivePage:=SchemaSheet;

        BuildSchemaPages(TMYX_SCHEMA(Node.Data));
      end
      else if(TObject(Node.Data) is TSchemaSubNode)then
      begin
        CatalogPageControl.ActivePage:=SchemaSheet;

        case TSchemaSubNode(Node.Data).SubNodeType of
          TSNTables:
            SchemaPageControl.ActivePage:=TablesTabSheet;
          TSNIndices:
            SchemaPageControl.ActivePage:=IndicesTabSheet;
          TSNViews:
            SchemaPageControl.ActivePage:=ViewsTabSheet;
          TSNStoredProcedures:
            SchemaPageControl.ActivePage:=StoredProcTabSheet;
          TSNEvents:
            SchemaPageControl.ActivePage:=EventsTabSheet;
          TSNDevDocs:
            SchemaPageControl.ActivePage:=DevDocTabSheet;
          TSNUsers:
            SchemaPageControl.ActivePage:=UsersTabSheet;
        end;
      end
      else if(TObject(Node.Data) is TMYX_SCHEMA_TABLE)then
      begin
        CatalogPageControl.ActivePage:=AssetSheet;

        EditTable('', CurrentSchema.schema_name,
          TMYX_SCHEMA_TABLE(Node.Data).table_name);
      end;
    end;
end;

procedure TAdminCatalogForm.FetchSchemaTableStatus(Sender: TObject);
var ptables: PMYX_SCHEMA_TABLE_STATUS;
  PMySQL: Pointer;
  SchemaName: WideString;
begin
  if(MySQLConn.Connected)then
  begin
    PMySQL:=myx_mysql_init;
    try
      if(myx_connect_to_instance(MySQLConn.user_connection.get_record_pointer,
        PMySQL)<>0)then
        raise EMyxError.Create(_('Unable to connect to the server.'));

      SchemaName:=TMYX_SCHEMA(TFetchDataThread(Sender).Target).schema_name;

      ptables:=myx_get_schema_table_status(PMySQL, '', SchemaName);
      if(ptables=nil)and(myx_mysql_errno(PMySQL)<>0)then
        raise EMyxSQLError.Create(_('Error while fetching Schema Table Status.'),
          myx_mysql_errno(PMySQL), myx_mysql_error(PMySQL));

      if(ptables<>nil)then
      begin
        try
          CurrentTableList:=TMYX_SCHEMA_TABLE_STATUS.Create(ptables);
        finally
          myx_free_schema_table_status(ptables);
        end;
      end
      else
        CurrentTableList:=nil;

    finally
      myx_mysql_close(PMySQL);
    end;
  end;
end;

procedure TAdminCatalogForm.FetchedSchemaTableStatus(Sender: TObject);
begin
  CurrentSchema:=TMYX_SCHEMA(TFetchDataThread(Sender).Target);

  BuildSchemaPages(CurrentSchema);
end;

procedure TAdminCatalogForm.ClearControls;
begin
  //Clear Table lists
  InitControls:=True;
  try
    TablesVST.BeginUpdate;
    try
      TablesVST.Clear;
      ClearTableInfos;
    finally
      TablesVST.EndUpdate;
    end;

    IndicesVST.BeginUpdate;
    try
      IndicesVST.Clear;
    finally
      IndicesVST.EndUpdate;
    end;
  finally
    InitControls:=False;
  end;
end;

procedure TAdminCatalogForm.BuildSchemaPages(Schema: TMYX_SCHEMA);
var
  i, j, k: integer;
  Node: PVirtualNode;
  rows, DataLenMyISAM: Int64;
  NodeData: PIndexNodeData;
  IndexCount, IndexColCount,
  IndexUniqueCount, IndexNotNullCount: integer;
begin
  ClearControls;

  //if nil is passed as schema, refresh current schema
  if(Schema=nil)then
  begin
    Schema:=CurrentSchema;
    CurrentSchema:=nil;
  end;

  if(CurrentSchema<>Schema)then
  begin
    if(CurrentTableList<>nil)then
    begin
      CurrentTableList.Free;
      CurrentTableList:=nil;
    end;
  end;

  if(CurrentTableList=nil)then
  begin
    MySQLConn.FetchData(KindOfData_SchemaTableStatus,
      FetchSchemaTableStatus, FetchedSchemaTableStatus,
      Schema, _('Fetching Schema Table Status ...'));

    Exit;
  end;

  TablesSchemaLbl.Caption:=Schema.schema_name;
  TablesTitleLbl.Caption:=format(_('All tables of the %s schema'),[Schema.schema_name]);

  IndicesSchemaLbl.Caption:=Schema.schema_name;
  IndicesTitleLbl.Caption:=format(_('All %s indices'),[Schema.schema_name]);
  ViewsTitleLbl.Caption:=Schema.schema_name+' views';
  StoredProcTitleLbl.Caption:=Schema.schema_name+' stored procedures';
  DevObjTitleLbl.Caption:=format(_('Developer documents stored in %s'),[Schema.schema_name]);
  UsersTitleLbl.Caption:=format(_('Users with privileges to connect to %s'),[Schema.schema_name]);


  //---------------------------------------------------------
  //Table Page

  InitControls:=True;

  TablesVST.BeginUpdate;
  try
    TablesVST.Clear;

    TablesVST.NodeDataSize:=sizeof(Pointer);

    rows:=0;
    CurrentSchemaDataLen:=0;
    CurrentSchemaIndexLen:=0;
    DataLenMyISAM:=0;
    for i:=0 to CurrentTableList.schema_tables.Count-1 do
    begin
      TablesVST.AddChild(nil, CurrentTableList.schema_tables[i]);
      rows:=rows+StrToInt64Def(CurrentTableList.schema_tables[i].rows, 0);
      CurrentSchemaDataLen:=CurrentSchemaDataLen+StrToInt64Def(CurrentTableList.schema_tables[i].data_length, 0);
      CurrentSchemaIndexLen:=CurrentSchemaIndexLen+StrToInt64Def(CurrentTableList.schema_tables[i].index_length, 0);
      if(CurrentTableList.schema_tables[i].table_type='MyISAM')then
        DataLenMyISAM:=DataLenMyISAM+StrToInt64Def(CurrentTableList.schema_tables[i].data_length, 0);
    end;

    if(CurrentTableList.schema_tables.Count>0)then
      TablesVST.FocusedNode:=TablesVST.GetFirst;
  finally
    TablesVST.EndUpdate;
    InitControls:=False;
  end;

  NumberOfTablesLbl.Caption:=IntToStr(CurrentTableList.schema_tables.Count);
  RowsCountLbl.Caption:=FormatFloat('#,###,###,##0', rows);
  TableDataLenLbl.Caption:=FormatFileSize(CurrentSchemaDataLen);
  TableIndexLenLbl.Caption:=FormatFileSize(CurrentSchemaIndexLen);

  //---------------------------------------------------------
  //Index Page

  InitControls:=True;

  IndicesVST.BeginUpdate;
  try
    IndicesVST.Clear;

    IndicesVST.NodeDataSize:=sizeof(IndexNodeData);

    IndexCount:=0;
    IndexColCount:=0;
    IndexUniqueCount:=0;
    IndexNotNullCount:=0;
    for i:=0 to CurrentTableList.schema_tables.Count-1 do
    begin
      for j:=0 to CurrentTableList.schema_tables[i].indexes.Count-1 do
      begin
        Node:=IndicesVST.AddChild(nil);
        NodeData:=IndicesVST.GetNodeData(Node);
        NodeData.Table:=CurrentTableList.schema_tables[i];
        NodeData.Index:=CurrentTableList.schema_tables[i].indexes[j];
        NodeData.Column:=nil;

        inc(IndexCount);
        if(CurrentTableList.schema_tables[i].indexes[j].unique=1)then
          inc(IndexUniqueCount);
        if(CurrentTableList.schema_tables[i].indexes[j].not_null=1)then
          inc(IndexNotNullCount);


        for k:=0 to CurrentTableList.schema_tables[i].indexes[j].index_columns.Count-1 do
        begin
          NodeData:=IndicesVST.GetNodeData(IndicesVST.AddChild(Node,
            CurrentTableList.schema_tables[i].indexes[j].index_columns[k]));
          NodeData.Table:=nil;
          NodeData.Index:=nil;
          NodeData.Column:=CurrentTableList.schema_tables[i].indexes[j].index_columns[k];

          inc(IndexColCount);
        end;
      end;
    end;
  finally
    IndicesVST.EndUpdate;
    InitControls:=False;
  end;

  NumberOfIndicesLbl.Caption:=IntToStr(IndexCount);
  IndexColCountLbl.Caption:=IntToStr(IndexColCount);
  IndexUniqueCountLbl.Caption:=IntToStr(IndexUniqueCount);
  IndexNotNullCountLbl.Caption:=IntToStr(IndexNotNullCount);

  //Reselect the node if the user tryed it select a different node
  //while fetching
  if(SchemataFrame.CatalogVST.FocusedNode<>nil)then
  begin
    SchemataFrame.CatalogVST.ClearSelection;
    SchemataFrame.CatalogVST.Selected[
      SchemataFrame.CatalogVST.FocusedNode]:=True;
  end;
end;

procedure TAdminCatalogForm.ClearTableInfos;
begin
  TablenameLbl.Caption:='';

  TableTypeLbl.Caption:='';
  RowFormatLbl.Caption:='';
  AutoIncLbl.Caption:='';
  CreateOptionsLbl.Caption:='';
  TableCommentLbl.Caption:='';

  RowsLbl.Caption:='';
  AvgRowLengthLbl.Caption:='';
  DataLengthLbl.Caption:='';
  MaxDataLenLbl.Caption:='';
  IndexLenLbl.Caption:='';
  DataFreeLbl.Caption:='';

  TblCreateTimeLbl.Caption:='';
  TblUpdateTimeLbl.Caption:='';
  TblCheckTimeLbl.Caption:='';
end;


procedure TAdminCatalogForm.TablesOptionsPageControlChange(
  Sender: TObject);
begin
  TablenamePnl.Parent:=TablesOptionsPageControl.ActivePage;
end;

procedure TAdminCatalogForm.Disconnected(var Message: TMessage);
begin
  ClearControls;

  SchemataFrame.ClearCatalogTree;

  DisableEnablePages(SchemaPageControl, False);
end;

procedure TAdminCatalogForm.Reconnected(var Message: TMessage);
begin
  SchemataFrame.ReloadSchemaTree;
  SchemataFrame.FillSchemaTree;

  DisableEnablePages(SchemaPageControl, True);
end;

procedure TAdminCatalogForm.SchemaListChanged(var Message: TMessage);
begin
  SchemataFrame.ReloadSchemaTree;
  SchemataFrame.FillSchemaTree;

  DisableEnablePages(SchemaPageControl, True);
end;

procedure TAdminCatalogForm.CheckTablesBtnClick(Sender: TObject);
var TableList: TTntStringList;
  i: integer;
  Action: TableAction;
  ActionIndex: integer;
  Selection: TNodeArray;
  NodeData: ^TMYX_TABLE_STATUS;
begin
  Selection:=nil;
  
  if(AdminCatalogTableCheckForm=nil)and(CurrentSchema<>nil)then
  begin
    if(TablesVST.SelectedCount=0)then
    begin
      TablesVST.SelectAll(False);
      {ShowModalDialog(_('No table selected'),
        _('You have to select at least one table.'),
        myx_mtInformation, _('OK'));

      Exit;}
    end;

    Selection:=TablesVST.GetSortedSelection(False);

    TableList:=TTntStringList.Create;
    try
      for i:=0 to Length(Selection)-1 do
      begin
        NodeData:=TablesVST.GetNodeData(Selection[i]);
        TableList.Add('`'+CurrentSchema.schema_name+'`.`'+
          NodeData.table_name+'`');
      end;

      if(Sender.ClassNameIs('TTntButton'))then
        ActionIndex:=TTntButton(Sender).Tag
      else if(Sender.ClassNameIs('TTntMenuItem'))then
        ActionIndex:=TTntMenuItem(Sender).Tag
      else
        ActionIndex:=1;

      case ActionIndex of
        1: Action:=taOptimize;
        2: Action:=taCheck;
      else
        Action:=taRepair;
      end;

      AdminCatalogTableCheckForm:=TAdminCatalogTableCheckForm.Create(self,
        TableList.Text, MySQLConn, Action);

      AdminCatalogTableCheckForm.Show;
    finally
      TableList.Free;
    end;
  end;
end;

procedure TAdminCatalogForm.SchemataFrameRefreshCatalogsSchemataListMIClick(
  Sender: TObject);
begin
  SchemataFrame.RefreshCatalogsSchemataListMIClick(Sender);
end;

procedure TAdminCatalogForm.RefreshBtnClick(Sender: TObject);
begin
  if(CurrentSchema<>nil)then
    BuildSchemaPages;
end;

procedure TAdminCatalogForm.EditTableMIClick(Sender: TObject);
var NodeData: ^TMYX_TABLE_STATUS;
begin
  if(TablesVST.FocusedNode<>nil)and(CurrentSchema<>nil)then
  begin
    NodeData:=TablesVST.GetNodeData(TablesVST.FocusedNode);

    if(NodeData<>nil)then
      EditTable('', CurrentSchema.schema_name, NodeData.table_name);
  end;
end;

procedure TAdminCatalogForm.EditorTableClose(Sender: TObject);
begin
  SchemaPageControl.ActivePage:=TablesTabSheet;
  CatalogPageControl.ActivePage:=SchemaSheet;
end;

procedure TAdminCatalogForm.EditorTableApplyedChanges(Sender: TObject);
begin
  if(CurrentSchema<>nil)then
    BuildSchemaPages;
end;

procedure TAdminCatalogForm.EditTable(Catalog: WideString;
  Schema: WideString; Table: WideString);
begin
  if(EditorTableForm=nil)then
  begin
    EditorTableForm:=TEditorTableForm.Create(self);
    EditorTableForm.SetEditMode(DBMEditMode_Online, MySQLConn);
    //EditorTableForm.SetDockLayout;
    //EditorTableForm.OnEditorClose:=EditorTableClose;
    EditorTableForm.OnApplyedChanges:=EditorTableApplyedChanges;
  end;

  EditorTableForm.InitControls:=True;
  try
    EditorTableForm.SetDatabaseVersion(
      myx_get_mysql_major_version(MySQLConn.MySQL),
      myx_get_mysql_minor_version(MySQLConn.MySQL));

    EditorTableForm.EditStatusTable(Catalog, Schema, Table,
      CurrentTableList);

    EditorTableForm.Show;
  finally
    EditorTableForm.InitControls:=False;
  end;
end;

procedure TAdminCatalogForm.CreateTableMIClick(Sender: TObject);
begin
  if(CurrentSchema<>nil)then
    EditTable('', CurrentSchema.schema_name, '');
end;

procedure TAdminCatalogForm.ShowHideTableDetails;
begin
  if(ShowTableDetails)then
  begin
    TableDetailsBtn.Caption:=_('<< Details');

    TableInfoSplitter.Visible:=True;
    TablesOptionsPageControl.Visible:=True;
    TableInfoSplitter.Top:=0;
    TableSumPnl.Top:=0;
  end
  else
  begin
    TableDetailsBtn.Caption:=_('Details >>');

    TableInfoSplitter.Visible:=False;
    TablesOptionsPageControl.Visible:=False;
  end;
end;

procedure TAdminCatalogForm.TableDetailsBtnClick(Sender: TObject);
begin
  ShowTableDetails:=Not(ShowTableDetails);
  ShowHideTableDetails;
end;

procedure TAdminCatalogForm.TablesVSTGetText(Sender: TBaseVirtualTree;
  Node: PVirtualNode; Column: TColumnIndex; TextType: TVSTTextType;
  var CellText: WideString);
var NodeData: ^TMYX_TABLE_STATUS;
begin
  NodeData:=TablesVST.GetNodeData(Node);
  if(NodeData<>nil)then
  begin
    case Column of
      0:
        CellText:=NodeData.table_name;
      1:
        CellText:=NodeData.table_type;
      2:
        CellText:=NodeData.rows;
      3:
        CellText:=FormatFileSize(StrToInt64Def(NodeData.data_length, 0));
      4:
        CellText:=FormatFileSize(StrToInt64Def(NodeData.index_length, 0));
      5:
        CellText:=NodeData.update_time;
    end;
  end;
end;

procedure TAdminCatalogForm.TablesVSTHeaderClick(Sender: TVTHeader;
  Column: TColumnIndex; Button: TMouseButton; Shift: TShiftState; X,
  Y: Integer);
begin
  if(Column<>Sender.SortColumn)then
    Sender.SortColumn:=Column
  else
    if(Sender.SortDirection=sdAscending)then
      Sender.SortDirection:=sdDescending
    else
      Sender.SortDirection:=sdAscending;
end;

procedure TAdminCatalogForm.TablesVSTCompareNodes(Sender: TBaseVirtualTree;
  Node1, Node2: PVirtualNode; Column: TColumnIndex; var Result: Integer);
var NodeData1, NodeData2: ^TMYX_TABLE_STATUS;
  FormatSettings: TFormatSettings;
begin
  NodeData1:=TablesVST.GetNodeData(Node1);
  NodeData2:=TablesVST.GetNodeData(Node2);
  if(NodeData1<>nil)and(NodeData2<>nil)then
  begin
    case Column of
      0:
        Result:=CompareText(NodeData1.table_name, NodeData2.table_name);
      1:
      begin
        if(NodeData1.table_type=NodeData2.table_type)then
          Result:=CompareText(NodeData1.table_name, NodeData2.table_name)
        else
          Result:=CompareText(NodeData1.table_type, NodeData2.table_type);
      end;
      2:
        Result:=StrToInt64Def(NodeData1.rows, 0)-StrToInt64Def(NodeData2.rows, 0);
      3:
        Result:=StrToInt64Def(NodeData1.data_length, 0)-StrToInt64Def(NodeData2.data_length, 0);
      4:
        Result:=StrToInt64Def(NodeData1.index_length, 0)-StrToInt64Def(NodeData2.index_length, 0);
      5:
      begin
        GetLocaleFormatSettings(GetSystemDefaultLCID, FormatSettings);

        FormatSettings.DateSeparator:='-';
        FormatSettings.TimeSeparator:=':';
        FormatSettings.ShortDateFormat:='YYYY-MM-DD HH:NN:SS';
        FormatSettings.LongDateFormat:='YYYY-MM-DD HH:NN:SS';

        Result:=Round(StrToDateTimeDef(NodeData1.update_time, Now,
          FormatSettings)*60*60-StrToDateTimeDef(NodeData2.update_time, Now,
          FormatSettings)*60*60);
      end;
    end;
  end;
end;

procedure TAdminCatalogForm.TablesVSTDblClick(Sender: TObject);
begin
  EditTableMIClick(self);
end;

procedure TAdminCatalogForm.TablesVSTKeyDown(Sender: TObject;
  var Key: Word; Shift: TShiftState);
begin
  if(Key=Ord('A'))and(ssCtrl in Shift)then
    TablesVST.SelectAll(False);
end;

procedure TAdminCatalogForm.TablesVSTChange(Sender: TBaseVirtualTree;
  Node: PVirtualNode);
var NodeData: ^TMYX_TABLE_STATUS;
begin
  if(InitControls)then
    Exit;

  NodeData:=TablesVST.GetNodeData(Node);
  if(NodeData<>nil)then
  begin
    TableNameLbl.Caption:=NodeData.table_name;

    TableTypeLbl.Caption:=NodeData.table_type;
    RowFormatLbl.Caption:=NodeData.row_format;

    if(NodeData.auto_increment<>'')then
      AutoIncLbl.Caption:=NodeData.auto_increment
    else
      AutoIncLbl.Caption:='-';

    if(NodeData.create_options<>'')then
      CreateOptionsLbl.Caption:=NodeData.create_options
    else
      CreateOptionsLbl.Caption:='-';

    if(NodeData.comment<>'')then
      TableCommentLbl.Caption:=NodeData.comment
    else
      TableCommentLbl.Caption:='-';

    RowsLbl.Caption:=NodeData.rows;
    AvgRowLengthLbl.Caption:=NodeData.avg_row_length;
    DataLengthLbl.Caption:=NodeData.data_length;
    MaxDataLenLbl.Caption:=NodeData.max_data_length;
    IndexLenLbl.Caption:=NodeData.index_length;
    DataFreeLbl.Caption:=NodeData.data_free;

    TblCreateTimeLbl.Caption:=NodeData.create_time;
    TblUpdateTimeLbl.Caption:=NodeData.update_time;
    TblCheckTimeLbl.Caption:=NodeData.check_time;
  end
  else
    ClearTableInfos;
end;

procedure TAdminCatalogForm.TablesVSTAfterCellPaint(
  Sender: TBaseVirtualTree; TargetCanvas: TCanvas; Node: PVirtualNode;
  Column: TColumnIndex; CellRect: TRect);
begin
  if(Column=0)then
    TablePNGImg.Draw(TargetCanvas,
      Rect(CellRect.Left+5, CellRect.Top+1, CellRect.Left+16+5, CellRect.Top+17));
end;

procedure TAdminCatalogForm.TablesVSTGetImageIndex(
  Sender: TBaseVirtualTree; Node: PVirtualNode; Kind: TVTImageKind;
  Column: TColumnIndex; var Ghosted: Boolean; var ImageIndex: Integer);
begin
  if(Column=0)then
    ImageIndex:=0;
end;

procedure TAdminCatalogForm.PaintNodeBKBarGraph(TargetCanvas: TCanvas;
  Node: PVirtualNode; Column: integer; ItemRect: TRect;
  Width: integer; PenColor: TColor; BrushColor: TColor);
begin
  TargetCanvas.Brush.Color:=$00F6EFF6;
  TargetCanvas.Pen.Color:=$00D0C9C8;

  TargetCanvas.Rectangle(Rect(TablesVST.Header.Columns[Column].Left-TablesVST.OffsetX,
      ItemRect.Top,
      TablesVST.Header.Columns[Column].Left-TablesVST.OffsetX+
        TablesVST.Header.Columns[Column].Width,
      ItemRect.Bottom-1));

  TargetCanvas.Brush.Color:=BrushColor;
  TargetCanvas.Pen.Color:=PenColor;

  if(Width>0)then
    TargetCanvas.Rectangle(Rect(TablesVST.Header.Columns[Column].Left-TablesVST.OffsetX,
      ItemRect.Top,
      TablesVST.Header.Columns[Column].Left-TablesVST.OffsetX+Width,
      ItemRect.Bottom-1));
end;

procedure TAdminCatalogForm.TablesVSTAfterItemErase(
  Sender: TBaseVirtualTree; TargetCanvas: TCanvas; Node: PVirtualNode;
  ItemRect: TRect);
var NodeData: ^TMYX_TABLE_STATUS;
begin
  NodeData:=TablesVST.GetNodeData(Node);
  if(NodeData<>nil)then
  begin
    if(CurrentSchemaDataLen>0)then
    begin
      PaintNodeBKBarGraph(TargetCanvas, Node, 3, ItemRect,
        Round((StrToInt64Def(NodeData.data_length, 0)/CurrentSchemaDataLen)*
        TablesVST.Header.Columns[3].Width),
        $00D79588, $00E9B1A6);
    end;

    if(CurrentSchemaIndexLen>0)then
    begin
      PaintNodeBKBarGraph(TargetCanvas, Node, 4, ItemRect,
        Round((StrToInt64Def(NodeData.index_length, 0)/CurrentSchemaIndexLen)*
        TablesVST.Header.Columns[4].Width),
        $00ECA1C3, $00ECBCD2);
    end;
  end;
end;

procedure TAdminCatalogForm.DropTableMIClick(Sender: TObject);
var i: integer;
  Selection: TNodeArray;
  NodeData: ^TMYX_TABLE_STATUS;
begin
  Selection:=TablesVST.GetSortedSelection(False);

  if(ShowModalDialog(_('Drop Tables'),
    _('Are you sure you want to drop the selected tables.'),
    myx_mtConfirmation, _('OK')+#13#10+_('Abort'))=1)then
  begin
    for i:=0 to TablesVST.SelectedCount-1 do
    begin
      NodeData:=TablesVST.GetNodeData(Selection[i]);
      MySQLConn.ExecuteDirect('DROP TABLE `'+CurrentSchema.schema_name+'`.'+
        '`'+NodeData.table_name+'`');
    end;

    BuildSchemaPages;
  end;
end;

procedure TAdminCatalogForm.IndicesVSTGetText(Sender: TBaseVirtualTree;
  Node: PVirtualNode; Column: TColumnIndex; TextType: TVSTTextType;
  var CellText: WideString);
var NodeData: PIndexNodeData;
begin
  if(Node<>nil)then
  begin
    NodeData:=IndicesVST.GetNodeData(Node);
    if(NodeData<>nil)then
    begin
      if(NodeData.Index<>nil)then
      begin
        case Column of
          0:
            CellText:=NodeData.Index.key_name;
          2:
            CellText:=NodeData.Index.index_type;
          3:
            if(NodeData.Index.unique=1)then
              CellText:='UNIQUE';
          4:
            if(NodeData.Index.not_null=1)then
              CellText:='NOT NULL';
        end;
      end
      else if(NodeData.Column<>nil)then
      begin
        case Column of
          0:
            CellText:=NodeData.Column.column_name;
        end;
      end;
    end;
  end;
end;

procedure TAdminCatalogForm.IndicesVSTAfterCellPaint(
  Sender: TBaseVirtualTree; TargetCanvas: TCanvas; Node: PVirtualNode;
  Column: TColumnIndex; CellRect: TRect);
var NodeData: PIndexNodeData;
  TxtRect: TRect;
  x: integer;
begin
  if not (csDestroying in ComponentState) then
  begin
    if(Column=0)then
    begin
      NodeData:=Sender.GetNodeData(Node);
      if(NodeData<>nil)then
      begin
        TxtRect:=Sender.GetDisplayRect(Node, Column, True);

        x:=TxtRect.Left-Sender.OffsetX;

        if(NodeData.Index<>nil)then
        begin
          if(Node.ChildCount>0)then
          begin
            if(Sender.Expanded[Node])then
              TreeBtnOpenPNGImg.Draw(TargetCanvas,
                Rect(x-16-12, CellRect.Top+4, x-16-4, CellRect.Top+16+4))
            else
              TreeBtnClosedPNGImg.Draw(TargetCanvas,
                Rect(x-16-12, CellRect.Top+4, x-16-4, CellRect.Top+16+4))
          end;

          IndexPNGImg.Draw(TargetCanvas,
            Rect(x-16, CellRect.Top+1, x, CellRect.Top+17));
        end
        else
          ColumnPNGImg.Draw(TargetCanvas,
            Rect(x-16, CellRect.Top+1, x, CellRect.Top+17));
      end;
    end
    else if(Column=1)then
    begin
      NodeData:=Sender.GetNodeData(Node);
      if(NodeData<>nil)then
        if(NodeData.Column=nil)then
        begin
          TablePNGImg.Draw(TargetCanvas,
            Rect(CellRect.Left, CellRect.Top+1, CellRect.Left+16, CellRect.Top+17));

          TargetCanvas.Font.Color:=clBlack;
          DrawWideStringText(TargetCanvas.Handle, PWideChar(NodeData.Table.table_name),
            Length(NodeData.Table.table_name),
            Rect(CellRect.Left+16+4, CellRect.Top,
              CellRect.Right, CellRect.Bottom),
            DT_LEFT, False);
        end;
    end;
  end;
end;

procedure TAdminCatalogForm.IndicesVSTGetImageIndex(
  Sender: TBaseVirtualTree; Node: PVirtualNode; Kind: TVTImageKind;
  Column: TColumnIndex; var Ghosted: Boolean; var ImageIndex: Integer);
begin
  if(Column=0)then
    ImageIndex:=0;
end;

procedure TAdminCatalogForm.IndicesVSTMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var HitInfo: THitInfo;
begin
  if(Sender.InheritsFrom(TBaseVirtualTree))then
  begin
    TBaseVirtualTree(Sender).GetHitTestInfoAt(X, Y, True, HitInfo);

    if(HitInfo.HitNode<>nil)and(HitInfo.HitColumn=0)then
    begin
      if(X<14)and(HitInfo.HitNode.ChildCount>0)then
      begin
        TBaseVirtualTree(Sender).Expanded[HitInfo.HitNode]:=
          Not(TBaseVirtualTree(Sender).Expanded[HitInfo.HitNode]);
      end;
    end
  end;
end;

procedure TAdminCatalogForm.IndicesVSTCompareNodes(
  Sender: TBaseVirtualTree; Node1, Node2: PVirtualNode;
  Column: TColumnIndex; var Result: Integer);
var NodeData1, NodeData2: PIndexNodeData;
begin
  NodeData1:=Sender.GetNodeData(Node1);
  NodeData2:=Sender.GetNodeData(Node2);
  if(NodeData1<>nil)and(NodeData2<>nil)then
  begin
    if(NodeData1.Table<>nil)and(NodeData1.Table<>nil)then
    begin
      case Column of
        0:
        begin
          if(NodeData1.Index.key_name=NodeData2.Index.key_name)then
            Result:=CompareText(NodeData1.table.table_name, NodeData2.table.table_name)
          else
            Result:=CompareText(NodeData1.Index.key_name, NodeData2.Index.key_name);
        end;
        1:
        begin
          if(NodeData1.table.table_name=NodeData2.table.table_name)then
            Result:=CompareText(NodeData1.Index.key_name, NodeData2.Index.key_name)
          else
            Result:=CompareText(NodeData1.table.table_name, NodeData2.table.table_name);
        end;
        2:
          Result:=CompareText(NodeData1.Index.index_type, NodeData2.Index.index_type);
        3:
          Result:=NodeData1.Index.unique-NodeData2.Index.unique;
        4:
          Result:=NodeData1.Index.not_null-NodeData2.Index.not_null;
      end;
    end;
  end;
end;

procedure TAdminCatalogForm.SchemataFrameSchemaTreeViewChanging(
  Sender: TObject; Node: TTntTreeNode; var AllowChange: Boolean);
begin
  //Do not allow change while fetching data
  AllowChange:=(Not(KindOfData_SchemaTableStatus in MySQLConn.DataBeingFetched));
end;

procedure TAdminCatalogForm.EditTableDataMIClick(Sender: TObject);
var cmd: WideString;
var NodeData: ^TMYX_TABLE_STATUS;
begin
  if(TablesVST.FocusedNode<>nil)then
  begin
    NodeData:=TablesVST.GetNodeData(TablesVST.FocusedNode);
    if(NodeData<>nil)then
      if(NodeData^<>nil)then
      begin
        cmd:=GetMySQLQueryBrowserCmd;

        //cmd:=cmd+' "-c'+MySQLConn.user_connection.connection_name+'"';
        cmd:=cmd+' "-u'+MySQLConn.user_connection.username+'"';
        cmd:=cmd+' "-p'+MySQLConn.user_connection.password+'"';
        cmd:=cmd+' "-h'+MySQLConn.user_connection.hostname+'"';
        cmd:=cmd+' "-P'+IntToStr(MySQLConn.user_connection.port)+'"';
        cmd:=cmd+' "-D'+CurrentSchema.schema_name+'"';
        cmd:=cmd+' "-selecttable=`'+CurrentSchema.schema_name+'`.`'+
          NodeData^.table_name+'`"';

        CreateSubProcess(cmd, '');
      end;
  end;
end;

procedure TAdminCatalogForm.DoSchemaTreeReloaded(Sender: TObject);
begin
  CatalogPageControl.ActivePage:=CatalogSheet;
end;

procedure TAdminCatalogForm.SchemataFrameCatalogVSTFocusChanging(
  Sender: TBaseVirtualTree; OldNode, NewNode: PVirtualNode; OldColumn,
  NewColumn: TColumnIndex; var Allowed: Boolean);
begin
  Allowed:=False;
  if(Not(KindOfData_SchemaTableStatus in MySQLConn.DataBeingFetched))then
    Allowed:=True;
end;

procedure TAdminCatalogForm.SchemataFrameCatalogVSTFocusChanged(
  Sender: TBaseVirtualTree; Node: PVirtualNode; Column: TColumnIndex);
var NodeData, ParentNodeData: ^TObject;
begin
  SchemataFrame.CatalogVSTChange(Sender, Node);

  NodeData:=Sender.GetNodeData(Node);

  if(NodeData<>nil)then
    if(NodeData^<>nil)then
    begin
      if(TObject(NodeData^) is TMYX_CATALOG)then
        CatalogPageControl.ActivePage:=CatalogSheet
      else if(TObject(NodeData^) is TMYX_SCHEMA)then
      begin
        CatalogPageControl.ActivePage:=SchemaSheet;

        BuildSchemaPages(TMYX_SCHEMA(NodeData^));
      end
      else if(TObject(NodeData^) is TSchemaSubNode)then
      begin
        if(CurrentSchema<>TSchemaSubNode(NodeData^).Schema)then
          BuildSchemaPages(TSchemaSubNode(NodeData^).Schema);

        CatalogPageControl.ActivePage:=SchemaSheet;

        case TSchemaSubNode(NodeData^).SubNodeType of
          TSNTables:
            SchemaPageControl.ActivePage:=TablesTabSheet;
          TSNIndices:
            SchemaPageControl.ActivePage:=IndicesTabSheet;
          TSNViews:
            SchemaPageControl.ActivePage:=ViewsTabSheet;
          TSNStoredProcedures:
            SchemaPageControl.ActivePage:=StoredProcTabSheet;
          TSNEvents:
            SchemaPageControl.ActivePage:=EventsTabSheet;
          TSNDevDocs:
            SchemaPageControl.ActivePage:=DevDocTabSheet;
          TSNUsers:
            SchemaPageControl.ActivePage:=UsersTabSheet;
        end;
      end
      else if(TObject(NodeData^) is TMYX_SCHEMA_TABLE)then
      begin
        if(Node.Parent<>nil)then
        begin
          ParentNodeData:=Sender.GetNodeData(Node.Parent);
          if(ParentNodeData<>nil)then
            if(ParentNodeData^<>nil)then
            begin
              if(TObject(ParentNodeData^) is TMYX_SCHEMA)then
              begin
                BuildSchemaPages(TMYX_SCHEMA(ParentNodeData^));

                CurrentSchema:=TMYX_SCHEMA(ParentNodeData^)
              end
              else if(TObject(ParentNodeData^) is TSchemaSubNode)then
              begin
                BuildSchemaPages(TSchemaSubNode(ParentNodeData^).Schema);

                CurrentSchema:=TSchemaSubNode(ParentNodeData^).Schema
              end
              else
                CurrentSchema:=nil;

              if(CurrentSchema<>nil)then
              begin
                CatalogPageControl.ActivePage:=AssetSheet;

                EditTable('', CurrentSchema.schema_name,
                  TMYX_SCHEMA_TABLE(NodeData^).table_name);
              end;
            end;
        end;
      end;
    end;
end;

procedure TAdminCatalogForm.SchemataFrameCreateNewSchemaMIClick(
  Sender: TObject);
begin
  SchemataFrame.CreateNewSchemaMIClick(Sender);
end;

procedure TAdminCatalogForm.SchemataFrameCopyAssetSQLMIClick(
  Sender: TObject);
begin
  SchemataFrame.CopyAssetSQLMIClick(Sender);

end;

end.

