#import "MQFieldViewer.h"

#import "MQBinaryViewer.h"
#import "MQTextViewer.h"
#import "MQImageViewer.h"

@implementation MQFieldViewer

- (IBAction)cancel:(id)sender
{
  [self close];  
}

- (IBAction)ok:(id)sender
{
  if (_editing)
    [delegate performSelector:@selector(fieldViewer:saveData:)
                   withObject:self
                   withObject:_data];
  
  [self close];
}


- (void)windowWillClose:(NSNotification*)notif
{
  [delegate performSelector:@selector(fieldViewerDidClose:)
                 withObject:self];
}


- (IBAction)changeView:(id)sender
{
  id viewer;
  [[[contentView subviews] lastObject] removeFromSuperview];
  viewer= [[formatPop selectedItem] representedObject];
  [[viewer view] setFrameSize:[contentView frame].size];
  [contentView addSubview:[viewer view]];
}

- (IBAction)load:(id)sender
{
}

- (IBAction)save:(id)sender
{
  NSSavePanel *panel= [NSSavePanel savePanel];
  [panel setTitle:@"Save Value to File"];
  if ([panel runModal] == NSFileHandlingPanelOKButton)
  {
    [_data writeToFile:[panel filename] atomically:NO];
  }  
}


- (id)init
{
  self= [super initWithWindowNibName:@"FieldViewer" owner:self];
  if (self)
  {
    [self loadWindow];
    _viewers= [[NSMutableArray alloc] init];
    [[NSNotificationCenter defaultCenter] addObserver:self 
                                             selector:@selector(windowWillClose:)
                                                 name:NSWindowWillCloseNotification
                                               object:[self window]];
  }
  return self;
}


- (void)dealloc
{
  [[NSNotificationCenter defaultCenter] removeObserver:self];
  [_info release];
  [_viewers release];
  [_data release];
  [super dealloc];
}


- (void)resetView
{
  unsigned int i, c= [_viewers count];
  id viewer;
  
  [formatPop removeAllItems];  
  for (i= 0; i < c; i++)
  {
    viewer= [_viewers objectAtIndex:i];
    [formatPop addItemWithTitle:[viewer label]];
    [[formatPop lastItem] setRepresentedObject:viewer];
  }
  
  [infoText setStringValue:[NSString stringWithFormat:@"Length: %i bytes", [_data length]]];

  viewer= [_viewers objectAtIndex:0];
  [[viewer view] setFrameSize:[contentView frame].size];
  [contentView addSubview:[viewer view]];
}

- (void)setDelegate:(id)deleg
{
  delegate= deleg;
}

- (void)setInfo:(NSDictionary*)info
{
  [columnText setStringValue:
    [NSString stringWithFormat:@"Column: %@", [info objectForKey:@"columnName"]]];
  _info= [info retain];
}

- (NSDictionary*)info
{
  return _info;
}

- (void)showData:(NSData*)data editable:(BOOL)editable
{
  id viewer;
  NSView *v;
  
  _data= [data retain];
  _editing= editable;
  
  viewer= [[[MQBinaryViewer alloc] initWithData:data] autorelease];
  [_viewers addObject:viewer];
  [viewer setEditable:editable];
  //[_viewers addObject:[[[MQTextViewer alloc] initWithData:data] autorelease]];
  
  if ([MQImageViewer canDisplayData:_data])
  {
    viewer= [[[MQImageViewer alloc] initWithData:data] autorelease];
    [_viewers addObject:viewer];
    [viewer setEditable:editable];
  }
  
  v= [[self window] contentView];
  if (editable)
  {
    [[v viewWithTag:11] setHidden:NO];
    [[v viewWithTag:12] setHidden:NO];
  }
  else
  {
    [[v viewWithTag:11] setHidden:YES];
    [[v viewWithTag:12] setHidden:YES];
  }

  [self resetView];
}


- (void)showTextData:(NSData*)data editable:(BOOL)editable
{
  id viewer;
  NSView *v;

  _data= [data retain];
  _editing= editable;

  viewer= [[[MQTextViewer alloc] initWithData:data] autorelease];
  [_viewers addObject:viewer];
  [viewer setEditable:editable];

  viewer= [[[MQBinaryViewer alloc] initWithData:data] autorelease];
  [_viewers addObject:viewer];
  [viewer setEditable:editable];
  
  v= [[self window] contentView];
  if (editable)
  {
    [[v viewWithTag:11] setHidden:NO];
    [[v viewWithTag:12] setHidden:NO];
  }
  else
  {
    [[v viewWithTag:11] setHidden:YES];
    [[v viewWithTag:12] setHidden:YES];
  }

  [self resetView];
}

@end
