//
//  MSourceTextView.m
//  MySQLGUICommon
//
//  Created by Alfredo Kojima on 5/19/05.
//  Copyright 2005 MySQL AB. All rights reserved.
//

#import "MSourceTextView.h"
#import "MSyntaxColoring.h"
#import "MSourceLayoutManager.h"

@implementation MSourceTextView


- (id)initWithFrame:(NSRect)rect
{
  self= [super initWithFrame:rect];
  if (self)
  {    
    [[self textContainer] replaceLayoutManager:[[[MSourceLayoutManager alloc] init] autorelease]];
  }
  return self;
}


- (void)dealloc
{
  [_syntaxColor release];
  [super dealloc];
}


- (NSArray *)completionsForPartialWordRange:(NSRange)charRange 
                        indexOfSelectedItem:(int *)index
{
  return [_syntaxColor completionListForWord:[[self string] substringWithRange:charRange]];
}


- (void)setSyntaxColorer:(MSyntaxColoring*)colorer
{
  if (_syntaxColor != colorer)
  {
    [_syntaxColor release];
    _syntaxColor= [colorer retain];    
  }
  [(MSourceLayoutManager*)[self layoutManager] setSyntaxColorer:colorer];
}

- (MSyntaxColoring*)syntaxColorer
{
  return _syntaxColor;
}


@end
